<?php

namespace App\Livewire\Forms;

use Livewire\Form;
use App\Models\Gauge;
use App\Models\Design;
use App\Models\Customer;
use App\Models\Suppliers;
use Livewire\Attributes\Rule;
use App\Livewire\Forms\BaseForm;
use Livewire\Attributes\Validate;

class DesignEditForm extends BaseForm
{
	public ?Design $design;

    #[Validate([
        'customers_id' => ['required', 'integer', 'exists:customers,id'],
        'description'  => ['required', 'string', 'max:255'],
        'issued'   => ['nullable', 'date'],
        'yarn' => ['nullable', 'string', 'max:30'],
        'factory_id' => ['required', 'integer', 'exists:suppliers,id'],
        'gauge_id' => ['required', 'integer', 'exists:gauges,id'],
    ])]
    public $customers_id, $description, $issued, $yarn, $factory_id, $gauge_id;

	public function clear(){
		$this->reset();
		$this->gauge_id = "";
		$this->factory_id = "";
		$this->customers_id = "";
	}

	public function set(Design $design)
	{
		$this->design = $design;
		$this->customers_id = $design->customers_id;
		$this->description = $design->description;
		$this->issued = $design->issued;
		$this->yarn = $design->yarn;
		$this->factory_id = $design->factory_id;
		$this->gauge_id = $design->gauge_id;
	}

	public function update()
	{
		session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-warning');
        $this->validate();
		session()->flash('message', 'Error Saving');
		session()->flash('alert-class', 'alert-danger');
		if(empty($this->design))
			Design::create($this->all());
		else
			$this->design->update(
				$this->all()
			);
		session()->flash('message', 'Saved!');
		session()->flash('alert-class', 'alert-success');
	}
}
