<?php

namespace App\Livewire\Forms;

use Livewire\Form;
use App\Models\Design;
use App\Models\Samples;
use App\Models\ShipmentLine;
use Livewire\Attributes\Rule;

class CommissionSSEditForm extends Form
{

	#[Rule('nullable|boolean')]
	public $exfty_update;
	#[Rule('nullable|date')]
	public $exfty;

	#[Rule('nullable|boolean')]
	public $collection_date_update;
	#[Rule('nullable|date')]
	public $collection_date;


	#[Rule('nullable|boolean')]
	public $complete_update = false;
	#[Rule('nullable|boolean')]
	public $complete = false;





	#[Rule('nullable|boolean')]
	public $fn_notes_update;
	#[Rule('nullable|string|max:500')]
	public $fn_notes;


	#[Rule('nullable|boolean')]
	public $rt_update;
	#[Rule('nullable|string|max:35')]
	public $rt;


	#[Rule('nullable|boolean')]
	public $qty_invoiced_update;
	#[Rule('nullable|string|max:35')]
	public $qty_invoiced;


	#[Rule('nullable|boolean')]
	public $finance_complete_update = false;
	#[Rule('nullable|boolean')]
	public $finance_complete = false;





	public function clear(){
		$this->reset();
	}

	public function update($drops)
	{
		session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-warning');
		$this->validate();
		session()->flash('message', 'Error Saving');
		session()->flash('alert-class', 'alert-danger');

		foreach(json_decode($drops) as $drop){
			$dropUpdate = ShipmentLine::with('customer_order_lines.colourways', 'shipments')->find($drop);
			if($this->exfty_update){
				$dropUpdate->exfty = $this->exfty;
			}
			if($this->collection_date_update){
				$dropUpdate->collection_date = $this->collection_date;
			}
			if($this->complete_update){
				$dropUpdate->complete = (bool) $this->complete;
			}
			if($this->fn_notes_update){
				$dropUpdate->fn_notes = $this->fn_notes;
			}
			if($this->rt_update){
				$dropUpdate->rt_invoice = $this->rt;
			}
			if($this->qty_invoiced_update){
				$dropUpdate->no_invoiced = $this->qty_invoiced == NULL ? 0 : $this->qty_invoiced;
			}
			if($this->finance_complete_update){
				$dropUpdate->invoiced = (bool) $this->finance_complete;
			}
			$dropUpdate->push();
		}
		session()->flash('message', 'Saved!');
		session()->flash('alert-class', 'alert-success');
	}
}
