<?php

namespace App\Livewire\Forms;

use App\Models\CustomerOrderLineQuantities;
use App\Models\CustomerOrderLines;
use App\Models\ShipmentLine;
use App\Models\ShipmentLineSizes;
use Livewire\Form;
use App\Models\Price;
use App\Models\Design;
use App\Models\Styles;
use App\Models\Colourways;
use Livewire\Attributes\Rule;
use App\Models\CustomerOrders;
use Illuminate\Support\Facades\Validator;

class CoSSForm extends Form
{
    public $ss = [];

    public function mount($data){
        $this->ss = $data;
    }

    public function save($val, $var){
        //Validation
        //TRIM & CLEAN

        //CLEAN $val

        // dd(explode('.', $var));

        $col = explode('.', $var)[3];
        $line = explode('.', $var)[2];

        // dd($col, explode('.', $var));

        switch ($col) {
            case "revised_exfty":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|date'],
                )->validate();
                $item = ShipmentLine::find($this->ss[$line]['shipment_lines_id']);
                $item->update(['exfty' => $val]);
                break;
            case "fn_notes":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'nullable|string'],
                )->validate();
                $item = ShipmentLine::find($this->ss[$line]['shipment_lines_id']);
                $item->update(['fn_notes' => $val]);
                break;
            case "no_invoiced":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'nullable|string'],
                )->validate();
                $item = ShipmentLine::find($this->ss[$line]['shipment_lines_id']);
                $item->update(['no_invoiced' ?? 0 => $val]);
                break;
            case "rt_invoice":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'nullable|string'],
                )->validate();
                $item = ShipmentLine::find($this->ss[$line]['shipment_lines_id']);
                $item->update(['rt_invoice' => $val]);
                break;
            case "shipped":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|boolean'],
                )->validate();
                $item = ShipmentLine::find($this->ss[$line]['shipment_lines_id']);
                $item->update(['complete' => $val]);
                break;
            case "finance_complete":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|boolean'],
                )->validate();
                $item = ShipmentLine::find($this->ss[$line]['shipment_lines_id']);
                $item->update(['invoiced' => $val]);
                break;
            case "sizes":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|numeric'],
                )->validate();
                $size = explode('.', $var)[4];
                $sizeVar = explode('.', $var)[5];
                // dd($size, explode('.', $var));
                if($sizeVar == 'shipped_qty'){
                    $sls = ShipmentLineSizes::find($this->ss[$line]['sizes'][$size]['sls_id']);
                    $sls->update(['shipped_qty' => $val]);
                }
                else{
                    $colq = CustomerOrderLineQuantities::find($this->ss[$line]['sizes'][$size]['colq_id']);
                    $colq->update([
                        $sizeVar => $val,
                    ]);
                }
                break;

        }

        // dd($var, $val);
    }
}
