<?php

namespace App\Livewire\Forms;

use Livewire\Form;
use App\Models\Price;
use App\Models\Design;
use App\Models\Styles;
use App\Models\Samples;
use App\Models\Colourways;
use App\Models\ShipmentLine;
use Livewire\Attributes\Rule;
use App\Models\CustomerOrders;
use App\Models\ShipmentLineSizes;
use App\Models\CustomerOrderLines;
use Illuminate\Support\Facades\Validator;
use App\Models\CustomerOrderLineQuantities;

class CPForm extends Form
{
    public $cp = [];

    public function mount($data){
        $this->cp = $data;
    }

    public function save($val, $var){
        //Validation
        //TRIM & CLEAN

        //CLEAN $val

        $col = explode('.', $var)[2];
        $line = explode('.', $var)[1];

        switch ($col) {
            case "description":
                Validator::make(
					['var' => $val],
					['var' => 'required|string|max:35'],
				)->validate();
				$item = Design::find($this->cp[$line]['designs_id']);
				$item->update(['description' => $val]);
                break;
            case "order_date":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|string|max:200'],
                )->validate();
                $item = CustomerOrders::find($this->cp[$line]['customer_orders_id']);
                $item->update(['order_date' => $val]);
                break;
            case "customer_po":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|string|max:35'],
                )->validate();
                $item = CustomerOrders::find($this->cp[$line]['customer_orders_id']);
                $item->update(['customer_po' => $val]);
                break;
            case "customer_ref":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|string|max:35'],
                )->validate();
                $item = Styles::find($this->cp[$line]['styles_id']);
                $item->update(['customer_ref' => $val]);
                break;
            case "colourways_name":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|string|max:35'],
                )->validate();
                $item = Colourways::find($this->cp[$line]['colourways_id']);
                $item->update(['name' => $val]);
                break;
            case "factory_order_yarn":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|boolean'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['factory_order_yarn' => $val]);
                // dd(ShipmentLine::find($this->cp[$line]['shipment_lines_id']));
                break;
            case "foy_ordered":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'nullable|boolean'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['foy_ordered' => $val]);
                break;
            case "foy_due":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'nullable|date'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['foy_due' => empty($val) ? NULL : $val]);
                break;
            case "foy_delivered":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'nullable|boolean'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['foy_delivered' => $val]);
                break;
            case "buttons":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'nullable|string'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['buttons' => $val]);
                break;
            case "buttons_done":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|boolean'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['buttons_done' => $val]);
                break;
            case "buttons_required":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|boolean'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['buttons_required' => $val]);
                break;
            case "buttons_due":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'nullable|date'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['buttons_due' => empty($val) ? NULL : $val]);
                break;
            case "labels":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'nullable|string'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['labels' => $val]);
                break;
            case "labels_done":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|boolean'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['labels_done' => $val]);
                break;
            case "care":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'nullable|string'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['care' => $val]);
                break;
            case "care_done":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|boolean'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['care_done' => $val]);
                break;
            case "pre_production_comments":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'nullable|string'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['pre_production_comments' => $val]);
                break;
            case "cp_photoshoot_deadline":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|date'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['cp_photoshoot_deadline' => $val]);
                break;
            case "sealer_deadline":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|date'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['sealer_deadline' => $val]);
                break;
            case "start_knit":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|date'],
                )->validate();
                $item = CustomerOrderLines::find($this->cp[$line]['customer_order_lines_id']);
                $item->update(['start_knit' => $val]);
                break;
            case "exfty":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|date'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['exfty' => $val]);
                break;
            case "cp_notes":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'nullable|string'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['cp_notes' => $val]);
                break;

            case "complete":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|boolean'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['complete' => $val]);
                break;
            case "sealer":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'nullable|string|max:200'],
                )->validate();
                $item = Samples::find($this->cp[$line]['sealer']->id);
                $item->update(['comments' => $val ?? ""]);
                break;
            case "shipment":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'nullable|string|max:200'],
                )->validate();
                $item = Samples::find($this->cp[$line]['shipment']->id);
                $item->update(['comments' => $val ?? ""]);
                break;

        }

        // dd($var, $val);
    }
}
