<?php

namespace App\Livewire\Forms;

use Livewire\Form;
use App\Models\Design;
use App\Models\Samples;
use App\Models\ShipmentLine;
use Livewire\Attributes\Rule;

class CPEditForm extends Form
{

	#[Rule('nullable|boolean')]
	public $exfty_update;
	#[Rule('nullable|date')]
	public $exfty;


	#[Rule('nullable|boolean')]
	public $customer_exfty_update;
	#[Rule('nullable|date')]
	public $customer_exfty;


	#[Rule('nullable|boolean')]
	public $customer_into_wh_update;
	#[Rule('nullable|date')]
	public $customer_into_wh;


	#[Rule('nullable|boolean')]
	public $start_knit_update;
	#[Rule('nullable|date')]
	public $start_knit;


	#[Rule('nullable|boolean')]
	public $sealer_deadline_update;
	#[Rule('nullable|date')]
	public $sealer_deadline;


	#[Rule('nullable|boolean')]
	public $photoshoot_deadline_update;
	#[Rule('nullable|date')]
	public $photoshoot_deadline;


	#[Rule('nullable|boolean')]
	public $factory_order_yarn_update;
	#[Rule('nullable|boolean')]
	public $factory_order_yarn;


    #[Rule('nullable|boolean')]
	public $foy_ordered_update;
	#[Rule('nullable|boolean')]
	public $foy_ordered;


    #[Rule('nullable|boolean')]
	public $foy_due_update;
	#[Rule('nullable|date')]
	public $foy_due;


    #[Rule('nullable|boolean')]
	public $foy_delivered_update;
	#[Rule('nullable|boolean')]
	public $foy_delivered;


	#[Rule('nullable|boolean')]
	public $yarn_comments_update;
	#[Rule('nullable|string|max:500')]
	public $yarn_comments;


	#[Rule('nullable|boolean')]
	public $buttons_required_update;
	#[Rule('nullable|boolean')]
	public $buttons_required;


	#[Rule('nullable|boolean')]
	public $buttons_due_update;
	#[Rule('nullable|date')]
	public $buttons_due;


	#[Rule('nullable|boolean')]
	public $button_done_update;
	#[Rule('nullable|boolean')]
	public $button_done;



	#[Rule('nullable|boolean')]
	public $label_done_update;
	#[Rule('nullable|boolean')]
	public $label_done;


	#[Rule('nullable|boolean')]
	public $care_done_update;
	#[Rule('nullable|boolean')]
	public $care_done;


	#[Rule('nullable|boolean')]
	public $button_update;
	#[Rule('nullable|string|max:500')]
	public $button;


	#[Rule('nullable|boolean')]
	public $label_update;
	#[Rule('nullable|string|max:500')]
	public $label;


	#[Rule('nullable|boolean')]
	public $care_comments_update;
	#[Rule('nullable|string|max:500')]
	public $care_comments;


	#[Rule('nullable|boolean')]
	public $sealer_status_update;
	#[Rule('nullable|in:pending,approved,rejected')]
	public $sealer_status;


	#[Rule('nullable|boolean')]
	public $sealer_sent_update;
	#[Rule('nullable|date')]
	public $sealer_sent;


	#[Rule('nullable|boolean')]
	public $sealer_comments_update;
	#[Rule('nullable|string|max:500')]
	public $sealer_comments;


	#[Rule('nullable|boolean')]
	public $shipment_status_update;
	#[Rule('nullable|in:pending,approved,rejected')]
	public $shipment_status;


	#[Rule('nullable|boolean')]
	public $shipment_sent_update;
	#[Rule('nullable|date')]
	public $shipment_sent;


	#[Rule('nullable|boolean')]
	public $shipment_comments_update;
	#[Rule('nullable|string|max:500')]
	public $shipment_comments;


	#[Rule('nullable|boolean')]
	public $comments_update;
	#[Rule('nullable|string|max:500')]
	public $comments;



	public function clear(){
		$this->reset();
	}

	public function update($drops)
	{
		session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-warning');
		$this->validate();
		session()->flash('message', 'Error Saving');
		session()->flash('alert-class', 'alert-danger');

		foreach(json_decode($drops) as $drop){
			$dropUpdate = ShipmentLine::with('customer_order_lines.colourways', 'shipments')->find($drop);
			if($this->exfty_update){
				$dropUpdate->exfty = $this->exfty;
			}
			if($this->customer_exfty_update){
				$dropUpdate->customer_order_lines->factory_cust_date = $this->customer_exfty;
			}
			if($this->customer_into_wh_update){
				$dropUpdate->customer_order_lines->wh_cust_date = $this->customer_into_wh;
			}
			if($this->start_knit_update){
				$dropUpdate->customer_order_lines->start_knit = $this->start_knit;
			}
			if($this->sealer_deadline_update){
				$dropUpdate->sealer_deadline = $this->sealer_deadline;
			}
			if($this->photoshoot_deadline_update){
				$dropUpdate->cp_photoshoot_deadline = $this->photoshoot_deadline;
			}

			if($this->factory_order_yarn_update){
				$dropUpdate->factory_order_yarn = $this->factory_order_yarn;
			}
            if($this->foy_ordered_update){
				$dropUpdate->foy_ordered = $this->foy_ordered;
			}
            if($this->foy_due_update){
				$dropUpdate->foy_due = $this->foy_due;
			}
            if($this->foy_delivered_update){
				$dropUpdate->foy_delivered = $this->foy_delivered;
			}
			if($this->yarn_comments_update){
				$dropUpdate->yarn_comments = $this->yarn_comments;
			}
			if($this->button_done_update){
				$dropUpdate->buttons_done = $this->button_done;
			}
            if($this->buttons_required_update){
				$dropUpdate->buttons_required = $this->buttons_required;
			}
            if($this->buttons_due_update){
				$dropUpdate->buttons_due = $this->buttons_due;
			}
			if($this->label_done_update){
				$dropUpdate->labels_done = $this->label_done;
			}
			if($this->care_done_update){
				$dropUpdate->care_done = $this->care_done;
			}
			if($this->button_update){
				$dropUpdate->buttons = $this->button;
			}
			if($this->label_update){
				$dropUpdate->labels = $this->label;
			}
			if($this->care_comments_update){
				$dropUpdate->care = $this->care_comments;
			}
			if($this->comments_update){
				$dropUpdate->cp_notes = $this->comments;
			}




			$dropUpdate->push();

			$sealer = Samples::where('sample_types_id', '3')->whereRelation('colourways.customer_order_lines.shipment_lines', 'id', '=', $drop)->latest()->first();
			$shipment = Samples::where('sample_types_id', '7')->whereRelation('colourways.customer_order_lines.shipment_lines', 'id', '=', $drop)->latest()->first();

			if(!empty($sealer)){
                if($this->sealer_status_update){
                    $sealer->status = $this->sealer_status;
                }
                if($this->sealer_sent_update){
                    $sealer->date_sent = $this->sealer_sent;
                }
                if($this->sealer_comments_update){
                    $sealer->production_comment = $this->sealer_comments;
                }
                $sealer->save();
			}


			if(!empty($shipment)){
                if($this->shipment_status_update){
                    $shipment->status = $this->shipment_status;
                }
                if($this->shipment_sent_update){
                    $shipment->date_sent = $this->shipment_sent;
                }
                if($this->shipment_comments_update){
                    $shipment->production_comment = $this->shipment_comments;
                }
                $shipment->save();
			}

		}
		session()->flash('message', 'Saved!');
		session()->flash('alert-class', 'alert-success');
	}
}
