<?php

// File: app/Http/Livewire/Forms/BaseForm.php

namespace App\Livewire\Forms;

use Livewire\Form;

class BaseForm extends Form
{
    protected function prepareForValidation($attributes)
    {
        foreach ($attributes as $key => &$value) {
            if (is_string($value)) {
                $value = strip_tags($value);             // Remove HTML tags
                $value = preg_replace('/[^a-zA-Z0-9\s-]/', '', $value); // Allow alphanumeric, spaces, and hyphen
                // Add more sanitization rules as needed
            }
        }

        $this->fill($attributes); // Update the form data


        // dd($attributes);

        return $attributes;
    }
}
