<?php

namespace App\Livewire\Forms;

use Livewire\Form;
use App\Models\Price;
use App\Models\Design;
use App\Models\Styles;
use App\Helper\Functions;
use App\Models\Colourways;
use App\Helper\Conversions;
use App\Models\ShipmentLine;
use Livewire\Attributes\Rule;
use App\Models\CustomerOrders;
use App\Models\ShipmentLineSizes;
use App\Models\CustomerOrderLines;
use Illuminate\Support\Facades\Validator;
use App\Models\CustomerOrderLineQuantities;

class AsosCPForm extends Form
{
    public $cp = [];

    public function mount($data){
        $this->cp = $data;
    }

    public function complete($val, $line){
        $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
        $item->update(['complete' => $val]);
    }

    /**
     * Force synchronous price cache refresh for immediate updates.
     * Called after price creation/update from critical path.
     */
    protected function refreshPriceCache($price)
    {
        try {
            // Run warmup job synchronously (not queued)
            \App\Jobs\WarmupPriceCacheJob::dispatchSync(
                $price->id,
                $price->colourways_id === null
            );
        } catch (\Exception $e) {
            \Log::error('Failed to refresh price cache from critical path', [
                'price_id' => $price->id,
                'error' => $e->getMessage()
            ]);
        }
    }

    public function save($val, $var){
        //Validation
        //TRIM & CLEAN

        //CLEAN $val

        $col = explode('.', $var)[2];
        $line = explode('.', $var)[1];

        switch ($col) {
            case "description":
                Validator::make(
					['var' => $val],
					['var' => 'required|string|max:35'],
				)->validate();
				$item = Design::find($this->cp[$line]['designs_id']);
				$item->update(['description' => $val]);
                break;
            case "customer_ref":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|string|max:35'],
                )->validate();
                $item = Styles::find($this->cp[$line]['styles_id']);
                $item->update(['customer_ref' => $val]);
                break;
            case "customer_samp_no":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|string|max:200'],
                )->validate();
                $item = Styles::find($this->cp[$line]['styles_id']);
                $item->update(['customer_samp_no' => $val]);
                break;
            case "green_seal_approval_comments":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|string|max:200'],
                )->validate();
                $item = Styles::find($this->cp[$line]['styles_id']);
                $item->update(['green_seal_approval_comments' => $val]);
                break;
            case "photo_shoot_sample_comments":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|string|max:200'],
                )->validate();
                $item = Styles::find($this->cp[$line]['styles_id']);
                $item->update(['photo_shoot_sample_comments' => $val]);
                break;
            case "customer_description":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|string|max:200'],
                )->validate();
                $item = Colourways::find($this->cp[$line]['colourways_id']);
                $item->update(['customer_description' => $val]);
                break;
            case "accessories":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|string|max:200'],
                )->validate();
                $item = Colourways::find($this->cp[$line]['colourways_id']);
                $item->update(['accessories' => $val]);
                break;
            case "testing_comments":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|string|max:200'],
                )->validate();
                $item = Colourways::find($this->cp[$line]['colourways_id']);
                $item->update(['testing_comments' => $val]);
                break;
            case "colourways_name":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|string|max:35'],
                )->validate();
                $item = Colourways::find($this->cp[$line]['colourways_id']);
                $item->update(['name' => $val]);
                break;
            case "composition":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|string|max:200'],
                )->validate();
                $item = Colourways::find($this->cp[$line]['colourways_id']);
                $item->update(['composition' => $val]);
                break;
            case "colour_approval_comments":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|string|max:200'],
                )->validate();
                $item = Colourways::find($this->cp[$line]['colourways_id']);
                $item->update(['colour_approval_comments' => $val]);
                break;
            case "cmt":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|numeric|min:0'],
                )->validate();
                
                // Check if we have a quote_id and if it's colourway-specific
                $shouldUpdate = false;
                if ($this->cp[$line]['quote_id']) {
                    $existingPrice = Price::find($this->cp[$line]['quote_id']);
                    // Only update if the price is specific to this colourway (not a generic price)
                    if ($existingPrice && $existingPrice->colourways_id == $this->cp[$line]['colourways_id']) {
                        $existingPrice->update(['cmt' => $val]);
                        $shouldUpdate = true;
                        // Force synchronous cache refresh
                        $this->refreshPriceCache($existingPrice);
                    }
                }
                
                if (!$shouldUpdate) {
                    // Check if a colourway-specific price already exists
                    $existingPrice = Price::where('style_versions_id', $this->cp[$line]['style_versions_id'])
                        ->where('colourways_id', $this->cp[$line]['colourways_id']) // Must match specific colourway
                        ->where(function($query) use ($line) {
                            if ($this->cp[$line]['phase_id']) {
                                $query->where('phase_id', $this->cp[$line]['phase_id']);
                            } else {
                                $query->whereNull('phase_id');
                            }
                        })
                        ->where(function($query) use ($line) {
                            if ($this->cp[$line]['colour_type']) {
                                $query->where('colour_type', $this->cp[$line]['colour_type']);
                            } else {
                                $query->whereNull('colour_type');
                            }
                        })
                        ->first();
                    
                    if ($existingPrice) {
                        // Update the existing colourway-specific price
                        $existingPrice->update(['cmt' => $val]);
                        $this->cp[$line]['quote_id'] = $existingPrice->id;
                        // Force synchronous cache refresh
                        $this->refreshPriceCache($existingPrice);
                    } else {
                        // Create new colourway-specific price
                        $newPrice = Price::create([
                            'style_versions_id' => $this->cp[$line]['style_versions_id'],
                            'colourways_id' => $this->cp[$line]['colourways_id'], // Always set specific colourway
                            'phase_id' => $this->cp[$line]['phase_id'],
                            'colour_type' => $this->cp[$line]['colour_type'],
                            'cmt' => $val,
                            'cmt_status' => 'confirmed', // Auto-confirm new prices from critical path
                            'quote_status' => 'confirmed',
                        ]);
                        // Update the local data with the new price id
                        $this->cp[$line]['quote_id'] = $newPrice->id;
                        
                        // Force synchronous cache refresh for critical path updates
                        // This ensures prices show immediately in shipment schedule
                        $this->refreshPriceCache($newPrice);
                    }
                }

                // Price resolution cache is automatically handled
                // No need to set prices_id as it's no longer used for caching

                break;
            case "quote":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|numeric|min:0'],
                )->validate();
                
                // Check if we have a quote_id and if it's colourway-specific
                $shouldUpdate = false;
                if ($this->cp[$line]['quote_id']) {
                    $existingPrice = Price::find($this->cp[$line]['quote_id']);
                    // Only update if the price is specific to this colourway (not a generic price)
                    if ($existingPrice && $existingPrice->colourways_id == $this->cp[$line]['colourways_id']) {
                        $existingPrice->update(['quote' => $val]);
                        $shouldUpdate = true;
                        // Force synchronous cache refresh
                        $this->refreshPriceCache($existingPrice);
                    }
                }
                
                if (!$shouldUpdate) {
                    // Check if a colourway-specific price already exists
                    $existingPrice = Price::where('style_versions_id', $this->cp[$line]['style_versions_id'])
                        ->where('colourways_id', $this->cp[$line]['colourways_id']) // Must match specific colourway
                        ->where(function($query) use ($line) {
                            if ($this->cp[$line]['phase_id']) {
                                $query->where('phase_id', $this->cp[$line]['phase_id']);
                            } else {
                                $query->whereNull('phase_id');
                            }
                        })
                        ->where(function($query) use ($line) {
                            if ($this->cp[$line]['colour_type']) {
                                $query->where('colour_type', $this->cp[$line]['colour_type']);
                            } else {
                                $query->whereNull('colour_type');
                            }
                        })
                        ->first();
                    
                    if ($existingPrice) {
                        // Update the existing colourway-specific price
                        $existingPrice->update(['quote' => $val]);
                        $this->cp[$line]['quote_id'] = $existingPrice->id;
                        // Force synchronous cache refresh
                        $this->refreshPriceCache($existingPrice);
                    } else{
                        // Create new colourway-specific price
                        $newPrice = Price::create([
                            'style_versions_id' => $this->cp[$line]['style_versions_id'],
                            'colourways_id' => $this->cp[$line]['colourways_id'], // Always set specific colourway
                            'phase_id' => $this->cp[$line]['phase_id'],
                            'colour_type' => $this->cp[$line]['colour_type'],
                            'quote' => $val,
                            'cmt_status' => 'confirmed', // Auto-confirm new prices from critical path
                            'quote_status' => 'confirmed',
                        ]);
                        // Update the local data with the new price id
                        $this->cp[$line]['quote_id'] = $newPrice->id;
                        
                        // Force synchronous cache refresh for critical path updates
                        // This ensures prices show immediately in shipment schedule
                        $this->refreshPriceCache($newPrice);
                    }
                }
                break;
            case "sizes":
                $size = explode('.', $var)[3];
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|numeric|min:0'],
                )->validate();
                $item = CustomerOrderLineQuantities::find($this->cp[$line]['sizes'][$size]['colq_id']);
                $item->update(['qty' => $val]);
                $item = ShipmentLineSizes::find($this->cp[$line]['sizes'][$size]['sls_id']);
                $item->update(['qty' => $val]);
                break;
            case "exfty":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|date'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['exfty' => $val]);
                break;
            case "customer_po":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|string|max:35'],
                )->validate();
                $item = CustomerOrders::find($this->cp[$line]['customer_orders_id']);
                $item->update(['customer_po' => $val]);
                break;
            case "order_sent_factory":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|date'],
                )->validate();
                $item = CustomerOrderLines::find($this->cp[$line]['customer_order_lines_id']);
                $item->update(['order_sent_factory' => $val]);
                break;
            case "bulk_yarn_order_date":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|date'],
                )->validate();
                $item = CustomerOrderLines::find($this->cp[$line]['customer_order_lines_id']);
                $item->update(['bulk_yarn_order_date' => $val]);
                break;
            case "bulk_yarn_order_comments":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|string|max:200'],
                )->validate();
                $item = CustomerOrderLines::find($this->cp[$line]['customer_order_lines_id']);
                $item->update(['bulk_yarn_order_comments' => $val]);
                break;
            case "bulk_yarn_order_delivery_date":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|date'],
                )->validate();
                $item = CustomerOrderLines::find($this->cp[$line]['customer_order_lines_id']);
                $item->update(['bulk_yarn_order_delivery_date' => $val]);
                break;
            case "bulk_yarn_order_delivery_comments":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|string|max:200'],
                )->validate();
                $item = CustomerOrderLines::find($this->cp[$line]['customer_order_lines_id']);
                $item->update(['bulk_yarn_order_delivery_comments' => $val]);
                break;
            case "start_knit":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|date'],
                )->validate();
                $item = CustomerOrderLines::find($this->cp[$line]['customer_order_lines_id']);
                $item->update(['start_knit' => $val]);
                break;
            case "start_knit_comments":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|string|max:200'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['start_knit_comments' => $val]);
                break;
            case "asn":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|string|max:35'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['asn' => $val]);
                break;
            case "asn_transferred_date":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|date'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['asn_transferred_date' => $val]);
                break;
            case "asn_transferred_comments":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|string|max:35'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['asn_transferred_comments' => $val]);
                break;
            case "collection_date":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|date'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['collection_date' => $val]);
                break;
            case "shipped_qty":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|numeric|min:0'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['shipped_qty' => $val]);
                break;
            case "rt_invoice":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|string'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['rt_invoice' => $val]);
                break;
            case "customer_invoice_no":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|string'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['customer_invoice_no' => $val]);
                break;
            case "pl_sent_date":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|date'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['pl_sent_date' => $val]);
                break;
            case "factory_invoice":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|numeric|min:0'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['factory_invoice' => $val]);
                break;
            case "order_received":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|string|max:200'],
                )->validate();
                $item = CustomerOrders::find($this->cp[$line]['customer_orders_id']);
                $item->update(['received' => $val]);
                break;
            case "payment_reference":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|string|max:200'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['payment_reference' => $val]);
                break;
            case "bol_reference":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|string|max:200'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['bol_reference' => $val]);
                break;
            case "bol_tracking_rt":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|string|max:200'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['bol_tracking_rt' => $val]);
                break;
            case "bol_tracking_factory":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|string|max:200'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['bol_tracking_factory' => $val]);
                break;
            case "container_no":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|string|max:200'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['container_no' => $val]);
                break;
            case "container_eta":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|string|max:200'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['container_eta' => $val]);
                break;
            case "complete":
                Validator::make(
                    ['var' => $val],
                    ['var' => 'required|boolean'],
                )->validate();
                $item = ShipmentLine::find($this->cp[$line]['shipment_lines_id']);
                $item->update(['complete' => $val]);
                break;
        }

        // dd($var, $val);
    }
}
