<?php

namespace App\Livewire\Forms;

use Livewire\Form;
use App\Models\Yarn;
use App\Models\YarnComposition;
use Livewire\Attributes\Locked;
use Illuminate\Support\Facades\Validator;

class AdminYarnForm extends Form
{
	#[Locked] 
    public $id;

	public function rules()
    {
        return [
			'suppliers_id' => 'required|numeric|min:1',
			'description' => 'required|string|max:35',
			'counts_id' => 'required|numeric|min:1',
			'materials.*.yarns_id' => 'nullable|numeric|min:1',
			'materials.*.id' => 'nullable|numeric|min:1',
			'materials.*.materials_id' => 'nullable|numeric|min:1',
			'materials.*.percentage' => 'nullable|numeric|min:0|max:100',
		];
	}


	public $suppliers_id;
	public $description;
	public $counts_id;
	public $materials = [];

	public function new(){
		$this->reset();
	}

	public function set($yarn)
	{
		$yarn = Yarn::with('yarn_compositions')->find($yarn);

		$this->id = $yarn->id;
		$this->description = $yarn->description;
		$this->suppliers_id = $yarn->suppliers_id;
		$this->counts_id = $yarn->counts_id;
		$this->materials = $yarn->yarn_compositions->toArray();
	}

	public function addComp(){
		$this->materials[] = [
			'materials_id' => "",
		];
	}

	public function update()
	{
		session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-warning');
		$this->validate();
		session()->flash('message', 'Error Saving');
		session()->flash('alert-class', 'alert-danger');

		$yarn = Yarn::updateOrCreate($this->only(['id']), $this->all());

		foreach($this->materials as $material){
			if(empty($material['percentage']) && !empty($material['id'])){
				YarnComposition::find($material['id'])->delete();
			}
			else{
				$material['yarn_id'] = $yarn->id;
				YarnComposition::updateOrCreate($material);
			}
		}

		session()->flash('message', 'Saved!');
		session()->flash('alert-class', 'alert-success');
	}
}