<?php

namespace App\Livewire\Forms;

use App\Models\YarnColours;
use Livewire\Form;
use App\Models\Yarn;
use App\Models\YarnComposition;
use Livewire\Attributes\Locked;
use Illuminate\Support\Facades\Validator;

class AdminYarnColoursForm extends Form
{
	#[Locked]
    public $id;

	public function rules()
    {
        return [
			'colours.*.id' => 'nullable|numeric|min:1',
			'colours.*.reference' => 'nullable|string|max:35',
			'colours.*.description' => 'nullable|string|max:35',
		];
	}


	public $colours = [];

	public function new(){
		$this->reset();
	}

	public function set($yarn)
	{
		$this->id = $yarn;
		$colours = YarnColours::where('yarn_id', $yarn)->get();

		$this->colours = $colours->toArray();
	}

	public function addColour(){
		$this->colours[] = [
			'reference' => "",
			'description' => "",
		];
	}

	public function update()
	{
		session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-warning');
		$this->validate();
		session()->flash('message', 'Error Saving');
		session()->flash('alert-class', 'alert-danger');

		foreach($this->colours as $colour){
			if(empty($colour['reference']) && !empty($colour['id'])){
				YarnColours::find($colour['id'])->delete();
			}
			else{
				$colour['yarn_id'] = $this->id;
				$c = YarnColours::updateOrCreate(['id' => $colour['id'] ?? 0], $colour);
			}
		}

		session()->flash('message', 'Saved!');
		session()->flash('alert-class', 'alert-success');
	}
}
