<?php

namespace App\Livewire\Forms;

use Livewire\Form;
use App\Models\Suppliers;
use Livewire\Attributes\Rule;
use App\Models\SupplierAddress;
use Livewire\Attributes\Locked;
use Illuminate\Support\Facades\Cache;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;

class AdminSupplierForm extends Form
{
	#[Locked]
    public $id;
	#[Locked]
	public $logo;


	public function rules()
    {
        return [
			'name' => 'required|string|max:35',
			'countries_id' => 'required|integer|min:0|not_in:0',
			'type' => 'required|in:yarn,fabric,accessory,factory,transporter',
			'mid' => 'nullable|string|max:35',
			'contact' => 'nullable|string|max:35',
			'phone' => 'nullable|string|max:35',
			'email' => [
				'nullable',
				function ($attribute, $value, $fail) {
					$emails = array_map('trim', explode(';', $value));
					$validator = Validator::make(['emails' => $emails], ['emails.*' => 'required|email']);
					if ($validator->fails()) {
						$fail('All email addresses must be valid.');
					}
				},
			],
			'finance_contact' => 'nullable|string|max:35',
			'finance_phone' => 'nullable|string|max:35',
			'finance_email' => 'nullable|email',
			'customs' => 'nullable|boolean',
			'payment_terms' => 'required|integer|min:0',
			'currency' => 'required|in:£,$,€',
			// 'factored' => 'nullable|boolean',
			'addresses.*.name' => 'required|string|max:35',
			'addresses.*.line1' => 'nullable|string|max:50',
			'addresses.*.line2' => 'nullable|string|max:50',
			'addresses.*.line3' => 'nullable|string|max:50',
			'addresses.*.city' => 'nullable|string|max:35',
			'addresses.*.region' => 'nullable|string|max:35',
			'addresses.*.postcode' => 'nullable|string|max:35',
			'addresses.*.countries_id' => 'required|integer|min:1',
		];
	}


	public $name;
	public $countries_id;
	public $type;
	public $mid;
	public $contact;
	public $phone;
	public $email;
	public $finance_contact;
	public $finance_phone;
	public $finance_email;
	public $payment_terms;
	public $currency;
	public $customs;
	public $addresses = [];

	public $removeAddresses = [];
	public function new(){
		$this->reset();
	}

	public function set($supplier)
	{
		$supplier = Suppliers::find($supplier);

		$this->id = $supplier->id;
		$this->name = $supplier->name;
		$this->countries_id = $supplier->countries_id;
		$this->type = $supplier->type;
		$this->mid = $supplier->mid;
		$this->contact = $supplier->contact;
		$this->phone = $supplier->phone;
		$this->email = $supplier->email;
		$this->finance_contact = $supplier->finance_contact;
		$this->finance_phone = $supplier->finance_phone;
		$this->finance_email = $supplier->finance_email;
		$this->payment_terms = $supplier->payment_terms;
		$this->currency = $supplier->currency;
		$this->factored = $supplier->factored;
		$this->customs = $supplier->customs;
		$this->addresses = $supplier->supplier_addresses->toArray();
	}

	public function deleteAddress($i){
		if(!empty($this->addresses[$i]['id'])){
			$this->removeAddresses[] = $this->addresses[$i]['id'];
		}
		unset($this->addresses[$i]);
	}

	public function newAddress(){
        $this->addresses[] = [
			'name' => "",
		];
    }

	public function update()
	{
		session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-warning');
		$this->validate();
		session()->flash('message', 'Error Saving');
		session()->flash('alert-class', 'alert-danger');

		$supplier = Suppliers::updateOrCreate($this->only(['id']), $this->all());

		foreach($this->removeAddresses as $address){
			SupplierAddress::find($address)->delete();
		}

		foreach($this->addresses as $address){
			$address['suppliers_id'] = $supplier->id;
			SupplierAddress::updateOrCreate(['id' => $address['id'] ?? 0], $address);
		}

        Cache::flush();

		session()->flash('message', 'Saved!');
		session()->flash('alert-class', 'alert-success');
	}
}
