<?php

namespace App\Livewire\Forms;

use Livewire\Form;
use App\Models\Sizes;
use Livewire\Attributes\Locked;
use Illuminate\Support\Facades\Validator;

class AdminSizeForm extends Form
{
	#[Locked] 
    public $id;

	public function rules()
    {
        return [
			'name' => 'required|string|max:35',
		];
	}


	public $name;

	public function new(){
		$this->reset();
	}

	public function set($size)
	{
		$size = Sizes::find($size);

		$this->id = $size->id;
		$this->name = $size->name;
	}

	public function update()
	{
		session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-warning');
		$this->validate();
		session()->flash('message', 'Error Saving');
		session()->flash('alert-class', 'alert-danger');

		$size = Sizes::updateOrCreate($this->only(['id']), $this->all());

		session()->flash('message', 'Saved!');
		session()->flash('alert-class', 'alert-success');
	}
}