<?php

namespace App\Livewire\Forms;

use Livewire\Form;
use App\Models\Seasons;
use Livewire\Attributes\Locked;
use Illuminate\Support\Facades\Validator;

class AdminSeasonForm extends Form
{
	#[Locked]
    public $id;

	public function rules()
    {
        return [
			'description' => 'required|string|max:4',
			'start_date' => 'required|date',
			'end_date' => 'required|date',
			'euro_rate' => 'required|numeric|min:0',
			'usd_rate' => 'required|numeric|min:0',
			'gbp_rate' => 'required|numeric|min:0',
			'markup' => 'required|numeric|min:0|max:100',
			'locked' => 'required|boolean',
			'no_days_yarn_interest' => 'required|integer|min:1|max:3650',
		];
	}


	public $description;
	public $start_date;
	public $end_date;
	public $euro_rate;
	public $usd_rate;
	public $gbp_rate;
	public $markup;
	public $locked;
	public $no_days_yarn_interest;

	public function new(){
		$this->reset();
		$this->no_days_yarn_interest = 365; // Set default value
		$this->season = new Seasons;
	}

	public function set($season)
	{
		$season = Seasons::find($season);

		$this->id = $season->id;
		$this->description = $season->description;
		$this->start_date = $season->start_date->format('Y-m-d');
		$this->end_date = $season->end_date->format('Y-m-d');
		$this->euro_rate = $season->euro_rate;
		$this->usd_rate = $season->usd_rate;
		$this->gbp_rate = $season->gbp_rate;
		$this->markup = $season->markup;
		$this->locked = $season->locked;
		$this->no_days_yarn_interest = $season->no_days_yarn_interest ?? 365;
	}

	public function update()
	{
		session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-warning');
		$this->validate();
		session()->flash('message', 'Error Saving');
		session()->flash('alert-class', 'alert-danger');

		$season = Seasons::updateOrCreate($this->only(['id']), $this->all());

		session()->flash('message', 'Saved!');
		session()->flash('alert-class', 'alert-success');
	}
}
