<?php

namespace App\Livewire\Forms;

use Livewire\Form;
use App\Models\SampleTypes;
use Livewire\Attributes\Locked;
use Illuminate\Support\Facades\Validator;

class AdminSampleTypeForm extends Form
{
	#[Locked] 
    public $id;

	public function rules()
    {
        return [
			'name' => 'required|string|max:35',
			'charge' => 'nullable|boolean',
			'charge_proto' => 'nullable|boolean',
			'charge_surcharge' => 'nullable|boolean',
		];
	}


	public
		$name,
		$charge,
		$charge_proto,
		$charge_surcharge;

	public function new(){
		$this->reset();
	}

	public function set($sampleType)
	{
		$sampleType = SampleTypes::find($sampleType);

		$this->id = $sampleType->id;
		$this->name = $sampleType->name;
		$this->charge = $sampleType->charge;
		$this->charge_proto = $sampleType->charge_proto;
		$this->charge_surcharge = $sampleType->charge_surcharge;
	}

	public function update()
	{
		session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-warning');
		$this->validate();
		session()->flash('message', 'Error Saving');
		session()->flash('alert-class', 'alert-danger');

		$sampleType = SampleTypes::updateOrCreate($this->only(['id']), $this->all());

		session()->flash('message', 'Saved!');
		session()->flash('alert-class', 'alert-success');
	}
}