<?php

namespace App\Livewire\Forms;

use Livewire\Form;
use App\Models\Materials;
use Livewire\Attributes\Locked;
use Illuminate\Support\Facades\Validator;

class AdminMaterialForm extends Form
{
	#[Locked] 
    public $id;

	public function rules()
    {
        return [
			'material' => 'required|string|max:35',
		];
	}


	public $material;

	public function new(){
		$this->reset();
	}

	public function set($material)
	{
		$material = Materials::find($material);

		$this->id = $material->id;
		$this->material = $material->material;
	}

	public function update()
	{
		session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-warning');
		$this->validate();
		session()->flash('message', 'Error Saving');
		session()->flash('alert-class', 'alert-danger');

		$material = Materials::updateOrCreate($this->only(['id']), $this->all());

		session()->flash('message', 'Saved!');
		session()->flash('alert-class', 'alert-success');
	}
}