<?php

namespace App\Livewire\Forms;

use Livewire\Form;
use App\Models\Gauge;
use Livewire\Attributes\Locked;
use Illuminate\Support\Facades\Validator;

class AdminGaugeForm extends Form
{
	#[Locked] 
    public $id;

	public function rules()
    {
        return [
			'gauge' => 'required|string|max:35',
		];
	}


	public $gauge;

	public function new(){
		$this->reset();
	}

	public function set($gauge)
	{
		$gauge = Gauge::find($gauge);

		$this->id = $gauge->id;
		$this->gauge = $gauge->gauge;
	}

	public function update()
	{
		session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-warning');
		$this->validate();
		session()->flash('message', 'Error Saving');
		session()->flash('alert-class', 'alert-danger');

		$gauge = Gauge::updateOrCreate($this->only(['id']), $this->all());

		session()->flash('message', 'Saved!');
		session()->flash('alert-class', 'alert-success');
	}
}