<?php

namespace App\Livewire\Forms;

use Livewire\Form;
use App\Models\Departments;
use Livewire\Attributes\Locked;
use Illuminate\Support\Facades\Validator;

class AdminDepartmentForm extends Form
{
	#[Locked]
    public $id;

	public function rules()
    {
        return [
			'description' => 'required|string|max:25',
			'zoho_name' => 'required|string|max:25',
			'type' => 'required|in:wholesale,commission',
			'hidden' => 'required|boolean',
		];
	}


	public $description;
	public $zoho_name;
	public $type;
	public $hidden;

	public function new(){
		$this->reset();
	}

	public function set($department)
	{
		$department = Departments::find($department);

		$this->id = $department->id;
		$this->description = $department->description;
		$this->zoho_name = $department->zoho_name;
		$this->type = $department->type;
		$this->hidden = $department->hidden;
	}

	public function update()
	{
		session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-warning');
		$this->validate();
		session()->flash('message', 'Error Saving');
		session()->flash('alert-class', 'alert-danger');

		$department = departments::updateOrCreate($this->only(['id']), $this->all());

		session()->flash('message', 'Saved!');
		session()->flash('alert-class', 'alert-success');
	}
}
