<?php

namespace App\Livewire\Forms;

use Livewire\Form;
use App\Models\Customer;
use Livewire\Attributes\Rule;
use App\Models\CustomerAddress;
use Livewire\Attributes\Locked;
use App\Models\CustomerInvoiceLayout;
use Illuminate\Support\Facades\Cache;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Storage;

class AdminCustomerForm extends Form
{

	#[Locked]
    public $id;
	#[Locked]
	public $logo;


	public function rules()
    {
        return [
			'name' => 'required|string|max:35',
			'zoho_customer' => 'nullable|string|max:50',
			'zoho_customer_tag' => 'nullable|string|max:50',
			'zoho_factored' => 'nullable|string|max:50',
			'countries_id' => 'required|integer|min:0|not_in:0',
			'show_mid' => 'nullable|boolean',
			'newLogo' => 'nullable|image|max:10240',
			'notes' => 'nullable|string|max:200',
			'contact' => 'nullable|string|max:35',
			'phone' => 'nullable|string|max:35',
			'email' => 'nullable|string',
			'finance_contact' => 'nullable|string|max:35',
			'finance_phone' => 'nullable|string|max:35',
			'finance_email' => 'nullable|string',
			'vat' => 'nullable|string|max:11',
			'eori' => 'nullable|string|max:15',
			'currency' => 'required|in:£,$,€',
			'notifyNewOrder' => 'nullable|string',
			'factored' => 'nullable|boolean',
			'customs' => 'nullable|boolean',
			'finance_notes' => 'nullable|string|max:200',
			'addresses.*.name' => 'required|string|max:35',
			'addresses.*.line1' => 'nullable|string|max:50',
			'addresses.*.line2' => 'nullable|string|max:50',
			'addresses.*.line3' => 'nullable|string|max:50',
			'addresses.*.city' => 'nullable|string|max:35',
			'addresses.*.region' => 'nullable|string|max:35',
			'addresses.*.postcode' => 'nullable|string|max:35',
			'addresses.*.countries_id' => 'required|integer|min:1',
			'samples_required.*' => 'nullable|boolean',
			'customerInvoiceLayouts.*' => 'nullable|integer',
			'sampleCharge.discount' => 'nullable|numeric|min:0|max:100',
			'sampleCharge.surcharge' => 'nullable|numeric|min:0|max:100',
			'sampleCharge.development' => 'nullable|numeric|min:0|max:100',
			'sampleCharge.freight' => 'nullable|boolean',
			'sampleCharge.default_commission' => 'nullable|numeric|min:0|max:100',
			'sampleCharge.default_discount' => 'nullable|numeric|min:0|max:100',

			'customer_payment_terms.*.percentage' => 'required|numeric|min:0|max:100',
            'customer_payment_terms.*.days' => 'required|integer|min:0',
            'commission_gemini_instructions' => 'nullable|string',
		];
	}


	public $name;
	public $zoho_customer;
	public $zoho_customer_tag;
	public $zoho_factored;
	public $countries_id;
	public $show_mid;
	public $notes;
	public $contact;
	public $phone;
	public $email;
	public $finance_contact;
	public $finance_phone;
	public $finance_email;
	public $vat;
	public $eori;
	public $currency;
	public $notifyNewOrder;
	public $factored;
	public $customs;
	public $finance_notes;
	public $addresses = [];
	public $samples_required = [];
	public $carryoverSamples = [];
	public $sampleCharge = [];
	public $sizeDefaults = [];
    public $customer_payment_terms = [];
	public $default_commission;
	public $default_discount;
	public $commission_gemini_instructions;

	public $customerInvoiceLayouts = [];

	public $newLogo;

	public $removeAddresses = [];

	public function new(){
		$this->reset();
	}

	public function set($customer)
	{
		$customer = Customer::find($customer);

		$this->id = $customer->id;
		$this->name = $customer->name;
		$this->zoho_customer = $customer->zoho_customer;
		$this->zoho_customer_tag = $customer->zoho_customer_tag;
		$this->zoho_factored = $customer->zoho_factored;
		$this->countries_id = $customer->countries_id;
		$this->show_mid = $customer->show_mid;
		$this->logo = $customer->logo;
		$this->notes = $customer->notes;
		$this->contact = $customer->contact;
		$this->phone = $customer->phone;
		$this->email = $customer->email;
		$this->finance_contact = $customer->finance_contact;
		$this->finance_phone = $customer->finance_phone;
		$this->finance_email = $customer->finance_email;
		$this->vat = $customer->vat;
		$this->eori = $customer->eori;
		$this->currency = $customer->currency;
		$this->factored = $customer->factored;
		$this->customs = $customer->customs;
		$this->finance_notes = $customer->finance_notes;
		$this->addresses = $customer->customer_addresses->toArray();
		$this->samples_required = json_decode($customer->samples_required, true) ?? [];
		$this->carryoverSamples = $customer->setting('carryover-samples-required') ?? [];
		$this->sampleCharge = $customer->setting('samples-charge') ?? [];
		$this->notifyNewOrder = empty($customer->setting('notifyNewOrder')) ? "" : $customer->setting('notifyNewOrder');
		$this->sizeDefaults = $customer->setting('size-defaults') ?? [];
		$this->default_commission = $customer->default_commission;
		$this->default_discount = $customer->default_discount;
		$this->commission_gemini_instructions = $customer->commission_gemini_instructions;

        // Load payment terms from the database
        $this->customer_payment_terms = $customer->customer_payment_terms()->get()->toArray();

        foreach($customer->customer_invoice_layouts as $layout){
            $this->customerInvoiceLayouts[$layout->incoterm] = $layout->invoice_layouts_id;
        }
	}

	public function deleteAddress($i){
		if(!empty($this->addresses[$i]['id'])){
			$this->removeAddresses[] = $this->addresses[$i]['id'];
		}
		unset($this->addresses[$i]);
	}

	public function newAddress(){
        $this->addresses[] = [
			'name' => "",
			'countries_id' => "",
		];
    }
    public function newSize(){
        $this->sizeDefaults[] = NULL;
    }

    public function removePaymentTerm($index)
    {
        unset($this->customer_payment_terms[$index]);
        $this->customer_payment_terms = array_values($this->customer_payment_terms); // Reindex array
    }

    public function addPaymentTerm()
    {
        $this->customer_payment_terms[] = ['percentage' => 0, 'days' => 0];
    }

	public function update()
	{
        // dd($this->sizeDefaults);
		session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-warning');
		$this->validate();
		session()->flash('message', 'Error Saving');
		session()->flash('alert-class', 'alert-danger');

		$values = $this->only([
			'name',
			'zoho_customer',
			'zoho_customer_tag',
			'zoho_factored',
			'countries_id',
			'show_mid',
			'logo',
			'notes',
			'contact',
			'phone',
			'email',
			'finance_contact',
			'finance_phone',
			'finance_email',
			'vat',
			'eori',
			'currency',
			'factored',
			'customs',
			'finance_notes',
			'samples_required',
			'default_commission',
			'default_discount',
			'commission_gemini_instructions',
		]);
		// dd($values['samples_required'], $this->samples_required);
		$values['samples_required'] = json_encode($values['samples_required']);
		if(!empty($this->newLogo)){
            $img = Image::make($this->newLogo)->resize(500, 500, function ($constraint) {
                $constraint->aspectRatio();
                $constraint->upsize();
            })->encode('png',80);
            $hash = md5($img->__toString());
            $path = "images/{$hash}.png";
            if(Storage::disk('public')->put($path, $img))
				$values['logo'] = $path;
		}
		$customer = Customer::updateOrCreate($this->only(['id']), $values);

        // Delete all existing payment terms for the customer
        $customer->customer_payment_terms()->delete();

        // Save new payment terms
        foreach ($this->customer_payment_terms as $term) {
            $customer->customer_payment_terms()->create([
                'percentage' => $term['percentage'],
                'days' => $term['days'],
            ]);
        }

		foreach($this->removeAddresses as $address){
			CustomerAddress::find($address)->delete();
		}

		foreach($this->addresses as $address){
			$address['customer_id'] = $customer->id;
			CustomerAddress::updateOrCreate([
                'id' => $address['id'] ?? 0,
            ],$address);
		}

        $customer->settings(['carryover-samples-required' => $this->carryoverSamples]);
        $customer->settings(['samples-charge' => $this->sampleCharge]);
        $customer->settings(['notifyNewOrder' => $this->notifyNewOrder]);
        $customer->settings(['size-defaults' => $this->sizeDefaults]);


        foreach($this->customerInvoiceLayouts as $l=>$layout){
            if(empty($layout)){
                $layouts = CustomerInvoiceLayout::where('customer_id', $customer->id)->where('incoterm', $l)->get();
                if(!$layouts->isEmpty()){
                    $layouts->first()->delete();
                }
            }
            else{
                $layout = CustomerInvoiceLayout::updateOrCreate([
                    'customer_id' => $customer->id,
                    'incoterm' => $l,
                ], [
                    'invoice_layouts_id' => $layout,
                ]);
                // dd($layout);
            }
        }

        // Avoid global cache flush; price/totals caches are gated by model events

		session()->flash('message', 'Saved!');
		session()->flash('alert-class', 'alert-success');
	}
}
