<?php

namespace App\Livewire\Forms;

use Livewire\Form;
use App\Models\Count;
use Livewire\Attributes\Locked;
use Illuminate\Support\Facades\Validator;

class AdminCountForm extends Form
{
	#[Locked] 
    public $id;

	public function rules()
    {
        return [
			'count' => 'required|string|max:10',
		];
	}


	public $count;

	public function new(){
		$this->reset();
	}

	public function set($count)
	{
		$count = Count::find($count);

		$this->id = $count->id;
		$this->count = $count->count;
	}

	public function update()
	{
		session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-warning');
		$this->validate();
		session()->flash('message', 'Error Saving');
		session()->flash('alert-class', 'alert-danger');

		$count = Count::updateOrCreate($this->only(['id']), $this->all());

		session()->flash('message', 'Saved!');
		session()->flash('alert-class', 'alert-success');
	}
}