<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Collection;
use App\Services\Zoho\InvoiceService;
use App\ValueObjects\ZohoInvoice;

class SendInvoicesJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /** @param Collection<ZohoInvoice> $invoices */
    public function __construct(
        public readonly Collection $invoices,
        public readonly int        $organisationId
    ) {}

    /** Handle the queued job. */
    public function handle(InvoiceService $zohoInvoices): void
    {
        // A single service call keeps retry / logging / error handling in one place.
        $zohoInvoices->send($this->invoices, $this->organisationId);
    }
}
