<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Services\ZohoBooksService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Livewire\Livewire;

class ZohoAuthComponent extends Component
{
    public $authUrl;
    public $authInProgress = false;
    public $errorMessage = '';

    public function mount()
    {
        $this->authUrl = $this->getAuthUrl();
    }

    public function getAuthUrl()
    {
        $zohoBooksService = new ZohoBooksService();
        return $zohoBooksService->getAuthUrl();
    }

    public function handleCallback(Request $request)
    {
        $this->authInProgress = true;

        $code = $request->query('code');

        $zohoBooksService = new ZohoBooksService();
        $accessToken = $zohoBooksService->getAccessToken($code);

        $zohoBooksService->setRefreshToken($accessToken->getRefreshToken());

        return Redirect::route('invoice.create');
    }

    public function updatedZohoCallbackData($value)
    {
        $this->handleCallback($value);
    }

    public function render()
    {
        return view('livewire.zoho-auth-component');
    }
}
