<?php

namespace App\Http\Livewire\YC;

use Livewire\Component;
use App\Models\YCOrders;
use App\Models\YCOrderLines;
use App\Models\Customer;
use App\Models\CustomerAgents;
use App\Models\Suppliers;
use App\Models\Yarn;
use App\Models\Seasons;
use App\Models\YCYarnSeasons;

use Carbon\Carbon;
use App\Helper\Functions;

use App\Mail\YCOrderCreated;
use Illuminate\Support\Facades\Mail;

use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Arr;

class YCOrdersList extends Component
{
	public $filter = ["customer" => ''];

    public $orders, $new = FALSE, $edit = FALSE, $customer_agents_id, $selectCustomer, $newOrder, $newAgent, $orderLines = [];

    public $customers, $seasons, $search;


    public $season, $spinner, $customer;

    public $delete = FALSE;

    protected $rules = [
        'filter.customer' => "numeric|min:0",
        'selectCustomer' => "required|numeric|min:0",
        'newOrder.customer_agents_id' => "required|numeric|min:0",
        'newOrder.date' => "required|date",
        'newOrder.notes' => "nullable|string|max:1000",
        'newOrder.address' => "nullable|string|max:500",
        'spinner' => "required|numeric|min:0",
        'orderLines.*.card' => "nullable|boolean",
        'orderLines.*.cone' => "nullable|boolean",
        'orderLines.*.part_cone' => "nullable|boolean",
        'orderLines.*.notes' => "nullable|string|max:200",
        'newAgent.name' => "nullable|string|max:50",
        'newAgent.email' => "nullable|email|max:100",
        'newAgent.phone' => "nullable|string|max:20",
    ];

    public function updatedSelectCustomer($val){
        $this->customer = $this->customers->find($val);
        if(!empty($this->customer->yc_address)){
            $this->newOrder->address = $this->customer->yc_address;
        }
    }

    public function updated($var, $value){
        $this->resetErrorBag();
        $vars = explode('.', $var);
        $this->{$vars[0]} = Functions::sanitise($this->{$vars[0]});
        $this->validateOnly($var);

        //dd($vars);
        // $current = $vars[0];
        // unset($vars[0]);
        // if(is_array($vars)){
        //     foreach($vars as $v=>$var){
        //         $current = $this->{$current}[$var];
        //     }
        //     dd($current);
        // }



    //     function getArrayValueByDotNotation(string $dotNotation)
    // {
    //     $parts = explode('.', $dotNotation);
    //     $baseVar = $this->{$parts[0]};
    //     unset($parts[0]);

    //     $currentValue = $baseVar;
    //     foreach ($parts as $part) {
    //         if (!isset($currentValue[$part])) {
    //             return null;
    //         }
    //     $currentValue = $currentValue[$part];
    //     }
    //     return $currentValue;
    // }


        if(is_array(array_shift($vars))){
            if($vars[0] == 'orderLines'){ //CHECK IF ORDER LINE IS EMPTY
                $empty = FALSE;
                foreach($this->{$vars[0]}[$vars[1]] as $l){
                    if(!empty($l)){
                        $empty = TRUE;
                    }
                }
                if(!$empty){
                    unset($this->{$vars[0]}[$vars[1]]);
                }
            }
        }
    }


    public function sanitise($var){
        if(!is_array($var)){
            $var = trim(strip_tags($var));
        }
        else{
                array_walk_recursive(
                    $var,
                    function(&$string) {
                        if (is_string($string)) {
                            $string = trim(strip_tags($string));
                        }
                    }
                );
        }
        return $var;
    }

    public function render()
    {
        Gate::authorize('yc:create');
        //$this->orders = YCOrders::with('customer_agents')->get();
        $this->customers = Customer::with('customer_agents')->get();

        //$this->season = 3;

        if(empty($this->newOrder)){
            $this->newOrder = new YCOrders;
            $this->newOrder->customer_agents_id = "";
            $this->newOrder->date = Carbon::now()->format('Y-m-d');
            $this->newAgent = new CustomerAgents;
        }

        return view('livewire.y-c.y-c-orders-list');
    }
    public function getSeasons(){
        return Seasons::has('y_c_yarn_seasons')->get();
    }
    public function getSpinners(){
        return Suppliers::whereRelation('yarns.y_c_yarn_seasons', 'seasons_id', $this->season)->get();
    }
    public function getYarns(){
        $query = YCYarnSeasons::where('seasons_id', $this->season);
        if(!empty($this->spinner))
            $query = $query->whereRelation('yarn', 'suppliers_id', $this->spinner);
        $query = $query->where('seasons_id', $this->season)
            ->with('yarn.suppliers', 'yarn.counts', 'yarn.yarn_compositions.materials');
        if(!empty($this->search)){
            $query = $query->where(function ($query){
                $query->whereRelation('yarn', 'description', 'LIKE', '%'.$this->search.'%')
                ->orWhereRelation('yarn.counts', 'count', 'LIKE', '%'.$this->search.'%')
                ->orWhereRelation('yarn.yarn_compositions.materials', 'material', 'LIKE', '%'.$this->search.'%');
                // ->orWhere('designs_id', 'LIKE', '%'.$this->filter['search'].'%')
                // ->orWhereRelation('designs', 'description', 'LIKE', '%'.$this->filter['search'].'%');
            });
        }

        return $query->get();
    }

    public function save($edit = FALSE){
        Gate::authorize('yc:create');
        //$this->sanitise();
        $this->validate();

        $this->newOrder->suppliers_id = $this->spinner;

        if($this->newOrder->customer_agents_id == 0){
            if(empty($this->newAgent->name))
            $this->addError('newAgent.name', 'Enter customer name.');
            if(empty($this->newAgent->email))
            $this->addError('newAgent.email', 'Enter customer email.');
            if(empty($this->newAgent->phone))
            $this->addError('newAgent.phone', 'Enter customer phone.');
        }

        if($this->newOrder->customer_agents_id == 0){
            $this->newAgent->customers_id = $this->selectCustomer;
            $this->newAgent->save();
            $this->newOrder->customer_agents_id = $this->newAgent->id;
        }
        $this->newOrder->save();
        $lines = [];
        foreach($this->orderLines as $ol=>$line){
            $ln = new YCOrderLines;
            $ln->y_c_yarn_seasons_id = $ol;
            if(!empty($line['swatch']))
            $ln->swatch = $line['swatch'];
            if(!empty($line['card']))
            $ln->card = $line['card'];
            if(!empty($line['cone']))
            $ln->cone = $line['cone'];
            if(!empty($line['part_cone']))
            $ln->part_cone = $line['part_cone'];
            if(!empty($line['notes']))
            $ln->notes = $line['notes'];

            $lines[] = $ln;
        }
        $this->newOrder->y_c_order_lines()->delete();
        $this->newOrder->y_c_order_lines()->saveMany($lines);

        if(empty($this->customer->yc_address) && !empty($this->newOrder->address)){
            $this->customer->yc_address = $this->newOrder->address;
            $this->customer->save();
        }

        $this->newOrder->load('suppliers', 'customer_agents.customers', 'y_c_order_lines.y_c_yarn_seasons.yarn.counts', 'y_c_order_lines.y_c_yarn_seasons.yarn');

        $bcc = [];
        foreach(explode(";", $this->newOrder->suppliers->yc_email) as $supplierEmail){
            if(!empty($supplierEmail))
                $bcc[] = $supplierEmail;
        };
        $bcc[] = $this->newOrder->customer_agents->email;
        try {
            $email = Mail::to('sue@roberttodds.com')->cc('oliver@roberttodds.com')->bcc($bcc)->queue(new YCOrderCreated($this->newOrder));
        } catch (Exception $e) {
            echo 'Caught exception: ',  $e->getMessage(), "\n";
        }
        $this->reset();
        session()->flash('message', 'Order Sent!');
		session()->flash('alert-class', 'alert-success');
    }
}
