<?php

namespace App\Http\Livewire\YC;

use App\Models\Yarn;
use App\Models\Count;
use Livewire\Component;
use App\Models\Spinners;
use App\Models\Materials;
use App\Models\Suppliers;
use App\Models\YarnComposition;
use App\Models\YarnColours;
use App\Models\Seasons;
use App\Models\YCYarnSeasons;

use App\Helper\Functions;


use App\Models\ColourwayYarns;

use Illuminate\Support\Facades\Gate;

class YCAdmin extends Component
{
    public $filter = ['search' => "", 'spinner' => ""];
    private $yarns, $seasons;
    public $spinners, $counts, $materials, $compositions = [], $colours = [], $im, $yarnSeasons = [];
    public $new, $edit, $editColour, $item, $i;

    protected $rules = [
        'item.suppliers_id' => 'required|integer|min:0|notin:0',
        'item.description' => 'required|string|max:200',
        'item.counts_id' => 'nullable|integer|min:0|notin:0',
        'item.count' => 'required|string|max:15',

		'yarnSeasons.*.*' => 'numeric|min:0'
	];

    public function mount(){
        $filter = $this->filters();
		if($filter != NULL)
			$this->filter = $filter;
		$this->getfilter();
    }

    public function render()
    {
        Gate::authorize('yc:read');
        $this->loadData();
        $seasons = Seasons::allCached();
        $this->getfilter();

        return view('livewire.y-c.y-c-admin', [
			'yarns' => $this->yarns,
            'seasons' => $seasons,
        ]);
    }
	public function updatedYarnSeasons($val, $var){
        $vars = explode('.', $var);
        $this->yarnSeasons = Functions::sanitise($this->yarnSeasons);
        $val = Functions::sanitise($val);
		$this->validateOnly('yarnSeasons.' . $var);

		$season = $vars[1];
		$yarn = $vars[0];
		if($val != NULL){
			//firstOrCreate not working...
			$v = YCYarnSeasons::firstOrNew(
				['yarns_id' => $yarn, 'seasons_id' => $season],
				//['price' => $val]
			);
			$v->price = $val;
			$v->save();
		}
		else{
			YCYarnSeasons::where(['yarns_id' => $yarn, 'seasons_id' => $season])->delete();
		}
		// dd($this->yarnSeasons);
		// dd($v);
	}
    private function loadData(){
        $this->yarns = Yarn::with('yarn_compositions.materials', 'yarn_colours', 'counts', 'y_c_yarn_seasons')->with('suppliers')
        ->where(function($query) {
            if ( !empty($this->filter['spinner'])) {
                $query->where('suppliers_id', $this->filter['spinner']);
            }
        })
        ->where(function($query) {
            $query->where('description', 'like', '%'.$this->filter['search'].'%');
        })
        ->where('agents', TRUE)->get();
        $this->spinners = Suppliers::has('yarns')->get();
        $this->materials = Materials::get();
        $this->counts = Count::get();
        $this->editLine = -1;

		foreach($this->yarns as $yarn){
			foreach($yarn->y_c_yarn_seasons as $season){
				//dd($season->price);
				//$this->yarnSeasons[$season->seasons_id] = [];
				$this->yarnSeasons[$season->yarns_id][$season->seasons_id] = $season->price;
			}
		}
		// dd($this->yarnSeasons);
    }
    public function edit($yarn){
        Gate::authorize('yc:update');
        $this->edit = TRUE;
        $this->item = Yarn::find($yarn);
        $this->item->count = $this->item->counts->count;

        foreach($this->item->yarn_compositions as $x => $composition){
            $this->compositions[$x]['material'] = $composition->materials_id;
            $this->compositions[$x]['percentage'] = $composition->percentage;
        }
    }
    public function new(){
        Gate::authorize('yc:create');
        $this->new = TRUE;
        $this->item = new Yarn();
        $this->item->countries_id = "";
        $this->item->counts_id = "";
        $this->item->suppliers_id = $this->filter['spinner'];
        $this->item->agents = TRUE;
    }
    public function save(){
        Gate::authorize('yc:update');
        session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-danger');
        $this->validate();
        session()->flash('message', 'Error Saving');
		session()->flash('alert-class', 'alert-danger');
        $count = Count::firstOrCreate(['count' => $this->item->count]);
        $this->item->counts_id = $count->id;
        unset($this->item->count);
		$this->item->agents = TRUE;
        $this->item->save();
        $yarnComp = [];
        foreach($this->compositions as $composition){
            if($composition['material'] != "" && array_key_exists('percentage', $composition) && $composition['percentage'] != ""){
                $material = new YarnComposition();
                $material->yarn_id = $this->item->id;
                $material->materials_id = $composition['material'];
                $material->percentage = $composition['percentage'];
                $yarnComp[] = $material;
            }
        }
        $this->item->yarn_compositions()->delete();
        $this->item->yarn_compositions()->saveMany($yarnComp);

        session()->flash('message', 'Saved');
		session()->flash('alert-class', 'alert-success');
        $this->item = $this->item->replicate();
        $this->item->count = $this->item->counts->count;
        //$this->close();
    }
    public function close(){
        $this->new = FALSE;
        $this->edit = FALSE;
        $this->compositions = [];
        $this->item = new Yarn();
        $this->dispatchBrowserEvent('closeNewModal');
        $this->loadData();
    }
	public function getCSV()
	{
		$csvFile = public_path('csv/' . "pinori.csv");
		$array = array('delimiter' => ',');
		$file_handle = fopen($csvFile, 'r');
		while (!feof($file_handle)) {
			$line_of_text[] = fgetcsv($file_handle, 0, $array['delimiter']);
		}
		fclose($file_handle);
		return $line_of_text;
	}
	public function test(){
		$csv = $this->getCSV();

		foreach($csv as $line){
			$materials = [];
			foreach(array_slice($line, 6) as $m=>$material){
                //dd($material, $line[2+$m]);
				if(!empty($material)){
					$mat = Materials::firstOrCreate(['material' => trim(strip_tags($material))]);
					$materials[] = [$line[2+$m], $mat->id];
				}
			}
			$count = Count::firstOrCreate(['count' => trim(strip_tags($line[1]))])->id;

			$yarn = Yarn::firstOrCreate([
				'suppliers_id' => 27,
				'description' => $line[0],
				'agents' => TRUE,
				'counts_id' => $count,
			]);

			$yarn->yarn_compositions()->delete();
			foreach($materials as $material){
				YarnComposition::create([
					'yarn_id' => $yarn->id,
					'materials_id' => $material[1],
					'percentage' => $material[0],
				]);
			}

            $price = YCYarnSeasons::firstOrCreate([
                'seasons_id' => 3,
                'yarns_id' => $yarn->id,
                'price' => trim(strip_tags($line[2])),
            ]);
		}
	}

    public function filters(){
		return auth()->user()->setting('yc-admin');
	}
	public function allCols(){
		$this->reset('filter');
	}
	public function getfilter(){
		$filter = $this->filters();
		if($filter != NULL){
			auth()->user()->settings(['yc-admin' => $this->filter]);
		}
		if($filter == NULL)
			auth()->user()->settings(['yc-admin' => []]);

		if($this->filter != $filter)
			auth()->user()->settings(['yc-admin' => $this->filter]);
	}
}
