<?php

namespace App\Http\Livewire;

use Livewire\Component;
use Livewire\Attributes\On;
use Illuminate\Support\Facades\DB;

class ViewAuditLog extends Component
{
    public $audits, $field;

    #[On('open-audit-log')]
    public function mount($model = NULL, $id = NULL, $field = NULL, $obj = NULL)
    {
        if($model != NULL && $id != NULL){
            $model = 'App\Models\\' . $model;
            $this->field = $field;

            $this->audits = $model::find($id)->audits()->with('user:id,name')->where('event', 'updated')->where('new_values', 'like', '%' . $field . '%')->get();
            foreach($this->audits as $a=>$audit){
                if(!empty(date_parse($audit->old_values[$field])['year'])){
                    $old = $this->audits[$a]->old_values;
                    $old[$field] = date_format(date_create($old[$field]), 'd-m-Y');
                    $this->audits[$a]->old_values = $old;
                }
                if(!empty(date_parse($audit->new_values[$field])['year'])){
                    $new = $this->audits[$a]->new_values;
                    $new[$field] = date_format(date_create($new[$field]), 'd-m-Y');
                    $this->audits[$a]->new_values = $new;
                }
            }
        }

    }
}
