<?php

namespace App\Http\Livewire\Traits;

use App\Facades\ZohoFacade;

trait HandlesZohoOAuth
{
    public function initiateZohoOAuth()
    {
        $authorizationUrl = ZohoFacade::getAuthUrl([
            'scope' => [
                'ZohoBooks.invoices.CREATE',
                'ZohoBooks.invoices.READ',
                'ZohoBooks.contacts.CREATE',
                'ZohoBooks.contacts.READ',
                'ZohoBooks.accountants.READ',
                'ZohoBooks.settings.READ',
                'ZohoBooks.vendorpayments.READ',
            ],
            'access_type' => 'offline',
            'prompt' => 'consent',
        ]);

        session(['oauth2state' => ZohoFacade::getState()]);

        $this->dispatch('open-zoho-oauth-popup', url: $authorizationUrl);
    }
}
