<?php

namespace App\Http\Livewire\Traits;

use Livewire\WithPagination;

trait Filterable
{
    public function mount()
    {
        $this->loadFilterSettings();
    }

    protected function loadFilterSettings()
    {
        $filterKey = $this->filterKey();
        $settings = auth()->user()->setting($filterKey);

        // Initialize $settings if null
        $settings = $settings ?? [];
        // dd($filterKey, $settings, $this->columnsVersion());

        foreach ($settings as $key => $value) {
            if ($key === 'columns') {
                // Check and update column settings based on version
                if (
                    !isset($value['version']) ||
                    $value['version'] < $this->columnsVersion()
                    ) {
                        $this->columns = $this->getDefaultColumns();
                        $this->saveFilterSettings();
                }
                else {
                    $this->columns = $value['data'];
                }


            } elseif (property_exists($this, $key)) {
                $this->$key = $value;
            }
        }
    }

    private function saveFilterSettings()
    {
        $filterData = [];
        foreach ($this->filters() as $p=>$property) {
            if($property == 'columns'){
                $filterData[$property] = ['version' => $this->columnsVersion(), 'data' => $this->$property];
            }
            else {
                $filterData[$property] = $this->$property;
            }
        }

        $filterKey = $this->filterKey();
        auth()->user()->settings([$filterKey => $filterData]);
    }

    // Abstract method for defining the filter key
    abstract protected function filterKey();

    // Abstract method for defining the filter properties
    abstract protected function filters(): array;

    // Abstract method for defining the columns version
    abstract protected function columnsVersion(): float;

    // Abstract method for defining the default columns
    abstract protected function getDefaultColumns(): array;
}

