<?php

namespace App\Http\Livewire;

use App\Models\Samples;
use Livewire\Component;
use Livewire\Attributes\On;

class SampleStatus extends Component
{

    public $statusID, $sample, $colourwayId, $sample_required, $type, $season_locked;

    public $sampleId, $add, $comments;

    #[On('refersh-sample-status.{statusID}')]
    public function refresh($sample){
        // dd($this->sample, $sample);
        $this->sample = (object) $sample;
    }
    public function mount($sample, $colourwayId, $sample_required, $type, $add = TRUE, $comments = FALSE, $season_locked = TRUE){
        $this->sample = json_decode($sample);
        $this->sampleId = $this->sample?->id;
        if(empty($sample))
            $this->sampleId = 0;
        $this->colourwayId = $colourwayId;
        $this->sample_required = $sample_required;
        $this->add = $add;
        $this->comments = $comments;
    }
    public function addSample($colourway, $sampleType){
		$sample = new Samples;
		$sample->colourways_id = $colourway;
		$sample->sample_types_id = $sampleType;
		$sample->save();
        $this->sample = (object) [
            'id' => $sample->id,
            'status' => 'pending',
            'approved' => NULL,
            'date_sent' => NULL,
            'approved_date' => NULL,
            'date_expected' => NULL,
        ];
	}

    public function render()
    {
        return view('livewire.sample-status');
    }
}
