<?php

namespace App\Http\Livewire\Sales\Pricing;

use App\Models\Styles;
use Livewire\Component;

class PricingSheetChunk extends Component
{
    public array $styles;

    public function mount(array $chunk){
        $query = Styles::
        with([
            'seasons:id,usd_rate,gbp_rate,euro_rate,locked',
            'designs:id,description',
            'customers:id,name,currency',
            'style_versions:id,name,factory_id,styles_id' => [
                'factories:id,currency',
                'prices' => [
                    'sizes:id,name',
                    'style_versions:id,name,factory_id,styles_id' => [
                        'factories:id,currency',
                        'styles:id,seasons_id,customers_id,designs_id' => [
                            'seasons:id,usd_rate,gbp_rate,euro_rate,locked',
                            'designs:id,description',
                            'customers:id,name,currency' => [
                                'customer_payment_terms'
                            ],
                        ]
                    ]
                ],
            ]
        ])->whereIn('id', $chunk);

        $this->styles = $query->get()->toArray();
    }

    public function render()
    {
        return view('livewire.sales.pricing.pricing-sheet-chunk');
    }
}
