<?php

namespace App\Http\Livewire\Sales\Pricing;

use App\Models\Price;
use App\Models\Sizes;
use App\Models\Styles;
use App\Models\Seasons;
use Livewire\Component;
use App\Models\Customer;
use App\Models\Suppliers;
use App\Models\Colourways;
use App\Models\ViewPrices;
use App\Models\Departments;
use Livewire\WithPagination;
use App\Models\StyleVersions;
use Illuminate\Support\Carbon;
use Livewire\Attributes\Computed;
use App\Livewire\Forms\PricingSheetForm;

class CustomerPricingSheet extends Component
{
	use WithPagination;

    public $list, $logo;
    public PricingSheetForm $form;

    public function render()
    {
        // $styles = Price::whereIn('id', $this->list)->get();
        $styles = Price::select(
            "prices.id as price_id",
            "prices.style_versions_id as style_versions_id",
            "styles.id as style_id",
            "styles.designs_id as design_id",
            "styles.customer_ref as customer_ref",
            "style_versions.name as style_version_name",
            "countries.country AS coo_name",
            "style_versions.id as style_version_id",
            "customers.id as customer_id",
            "customers.logo",
            "customers.currency as cust_currency",
            "styles.cancelled AS style_cancelled",
            "prices.quote_status AS quote_status",
            "prices.quote AS quote",
            "prices.min_qty",
            "prices.customer_notes",
            "prices.cmt_status",
            "prices.cmt",
            "prices.quotes_sent",
            "designs.description",
        )
        ->selectRaw("
                (select
                    group_concat(
                        distinct y.description separator ','
                    )
                from yarns y
                join yarn_colours yc on yc.yarn_id = y.id
                join colourway_yarns cy on cy.yarn_colours_id = yc.id
                join colourways c on c.id = cy.colourways_id
                join style_versions sv on sv.id = c.style_versions_id and sv.id = style_versions.id
            ) AS yarns")
        ->selectRaw("
                (select
                    c.image
                from
                        style_versions sv
                        left join colourways c on sv.id = style_versions.id
                where c.style_versions_id = sv.id and (c.image is not null)
                limit 1
            ) AS image
        ")
        ->join('style_versions', 'style_versions.id', '=', 'prices.style_versions_id')
        ->join('styles', 'styles.id', '=', 'style_versions.styles_id')
        ->join('designs', 'designs.id', '=', 'styles.designs_id')
        ->join('suppliers', 'suppliers.id', '=', 'style_versions.factory_id')
        ->join('customers', 'customers.id', '=', 'styles.customers_id')
        ->join('countries', 'countries.id', '=', 'suppliers.countries_id')

        ->orderByRaw("style_versions.styles_id, style_versions.id")

        ->with('style_versions.styles.customers.customer_payment_terms')

        ->whereIn('prices.id', $this->list)->get();

        // $styles = ViewPrices::whereIn('price_id', $this->list)->get();
        // dd($styles->first());

        $this->logo = url(asset('storage/' . Customer::find($styles->first()->customer_id)->logo));



        foreach ($styles as $s => $style) {
            $styles[$s]->yarns = explode(',', $style->yarns);

            $quotes = $style->quotes_sent ?? [];

            foreach ($quotes as $q => $quote) {
                if (!empty($quote['date_sent'])) {
                    $quotes[$q]['date_sent'] = \Carbon\Carbon::parse($quote['date_sent'])->toDateString();
                }
            }

            $styles[$s]->quotes_sent = $quotes;
        }

        // dd($styles);
        $this->form->set($styles->toArray());

        return view('livewire.sales.pricing.customer-pricing-sheet');
    }

    public function updated($var, $val){
        if (str_starts_with($var, 'form.styles.')) {
            $this->updatePriceField($var, $val);
        }
    }

    public function updatePriceField($var, $val)
    {
        // Only respond to date changes
        if (!str_starts_with($var, 'form.styles.')) {
            return;
        }

        // Parse: form.styles.0.quotes_sent.0.date_sent
        $parts = explode('.', $var);

        if (count($parts) === 6 && $parts[3] === 'quotes_sent') {
            $styleIndex = $parts[2];
            $quoteIndex = $parts[4];
            $field = $parts[5]; // should be 'date_sent'

            $price = Price::find($this->form->styles[$styleIndex]['price_id']);

            $quotes = $price->quotes_sent;
            $quotes[$quoteIndex]['date_sent'] = $val;

            $price->quotes_sent = $quotes;
            $price->save();
        }
    }

	public function mount($array){
        $this->list = json_decode($array);
	}

    public function markAsSent(){
        foreach($this->form->styles as $price){
            $price = Price::find($price['price_id']);
            $quotes = $price->quotes_sent;
            // $price->quotes_sent = NULL;
            // $price->save();

            $quotes[] = [
                'quote' => $price->quote,
                'date_sent' => Carbon::today(),
                'sent_by_id' => auth()->id(),
            ];

            $price->quotes_sent = $quotes;
            $price->save();
        }
    }
}
