<?php

namespace App\Http\Livewire\Sales\Orders;

use App\Models\Sizes;
use App\Models\Styles;
use App\Models\Seasons;
use Livewire\Component;
use App\Models\Customer;
use App\Helper\Functions;
use App\Models\Colourways;
use App\Models\Departments;
use Livewire\Attributes\On;
use Livewire\WithFileUploads;
use App\Models\CustomerOrders;
use App\Models\CustomerAddress;
use Illuminate\Validation\Rule;
use Livewire\Attributes\Computed;
use App\Models\CustomerOrderFiles;
use App\Models\CustomerOrderLines;
use Illuminate\Support\Facades\Gate;
use App\Livewire\Forms\OrdersEditForm;
use App\Livewire\Forms\OrdersEditFormDev;

class OrdersNew extends Component
{
    public $department, $season, $customer, $incoterms, $deliveryaddress, $po, $date;

	public function rules()
    {
        return [
            'department' => 'required|exists:departments,id',
            'season' => 'required|exists:seasons,id',
            'customer' => 'required|exists:customers,id',
            'deliveryaddress' => 'required|exists:customer_addresses,id',
            'incoterms' => 'required|in:EXW,FCA,CPT,CIP,DAP,DPU,DDP,FAS,FOB,CFR,CIF',
            'po' => [
                'required',
                'string',
                'max:35',
                Rule::unique('customer_orders', 'customer_po')->where(function ($query) {
                    return $this->customer
                        ? $query->where('customers_id', $this->customer)
                        : $query->whereNull('customers_id');
                }),
            ],
            'date' => 'required|date',
        ];
    }

	#[Computed()]
	public function departments(){
		return Departments::where('type', 'wholesale')->where('hidden', false)->get();
	}
	#[Computed]
	public function seasons(){
		return Seasons::allCached()->where('locked', FALSE);
	}
    #[Computed(cache: true, key: 'customers-with-customer_addresses')]
	public function customers(){
		return Customer::allCached()->load('customer_addresses');
	}
	#[Computed()]
	public function deliveryAddresses(){
        if($this->customer)
		    return CustomerAddress::where('customer_id', $this->customer)->get();
	}

    public function render()
    {
        return view('livewire.sales.orders.orders-new');
    }

	public function save(){
		Gate::authorize('order:update');
        session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-warning');

        $this->validate();

        session()->flash('message', 'Validated');
		session()->flash('alert-class', 'alert-warning');

        try {
            $order = CustomerOrders::create([
                'order_type' => 'wholesale',
                'departments_id' => $this->department,
                'seasons_id' => $this->season,
                'customers_id' => $this->customer,
                'incoterms' => $this->incoterms,
                'customer_addresses_id' => $this->deliveryaddress,
                'customer_po' => $this->po,
                'order_date' => $this->date,
            ]);
            session()->flash('message', 'Done!');
            session()->flash('alert-class', 'alert-success');
            $this->dispatch('open-modal', name: 'edit-dev');
            $this->dispatch('edit-order', order: $order->id);
        } catch (\Exception $e) {
            return $e->getMessage();
        }

        $this->reset();

        session()->flash('message', 'Done??');
		session()->flash('alert-class', 'alert-warning');
	}


	public function deleteFile($file, $id, $dir){
		CustomerOrderFiles::find($id)->delete();
		$this->form->open($this->order);
        $this->run($this->order->id);
	}

}
