<?php

namespace App\Http\Livewire\Sales\Orders;

use App\Models\Sizes;
use App\Models\Styles;
use App\Models\Seasons;
use Livewire\Component;
use App\Models\Customer;
use App\Helper\Functions;
use App\Models\Colourways;
use App\Models\Departments;
use Livewire\Attributes\On;
use Livewire\WithFileUploads;
use App\Models\CustomerOrders;
use Livewire\Attributes\Computed;
use App\Models\CustomerOrderFiles;
use App\Models\CustomerOrderLines;
use Illuminate\Support\Facades\Gate;
use App\Livewire\Forms\OrdersEditForm;
use App\Livewire\Forms\OrdersEditFormDev;

class OrdersEdit extends Component
{
	use WithFileUploads;
	public $order, $itemToAdd, $itemPicker = FALSE, $deletedItems = FALSE, $itemPickerChange = FALSE, $itemPickerLine, $itemSearch = "", $viewOnly, $activeLineID, $changeSeasonCust;
	public $new = FALSE;

    public $quickAdd = FALSE, $multipleShipmentLines = FALSE, $lineEdit;
	public OrdersEditFormDev $form;

	#[Computed()]
	public function departments(){
		return Departments::where('type', 'wholesale')->where('hidden', false)->get();
	}
	#[Computed()]
	public function seasons(){
		return Seasons::where('locked', FALSE)->get();
	}
	#[Computed()]
	public function customers(){
		return Customer::with('customer_addresses')->get();
	}
	#[Computed()]
	public function phases(){
		return \App\Models\Phase::all();
	}

    #[Computed()]
    public function deletedItemsList(){
        return CustomerOrderLines::where('customer_orders_id', $this->order->id)->onlyTrashed()->get();
    }

	#[Computed]
	public function items(){
        if(!empty($this->form->orderEdit['customers_id'])){
            return Colourways::with([
                'style_versions:id,factory_id,styles_id,name' => [
                    'styles:id,designs_id,customer_ref' => [
                        'designs:id,description',
                    ],
                    'factories:id,name',
                    'prices:id,style_versions_id,quote_status,quote,colourways_id,colour_type',
                ]
            ])
            ->whereRelation('style_versions.styles', 'customers_id', '=', $this->form->orderEdit['customers_id'] ?? 0)
            ->whereRelation('style_versions.styles', 'seasons_id', '=', $this->form->orderEdit['seasons_id'] ?? 0)
            ->where('cancelled', 0)
            ->whereRelation('style_versions.styles', 'cancelled', '=', 0)
            ->where(function ($query) {
                if(!empty($this->itemSearch))
                    $query->where('name', '=', $this->itemSearch)
                        ->orWhereRelation('style_versions', 'name', 'like', "%{$this->itemSearch}%")
                        ->orWhereRelation('style_versions.styles', 'customer_ref', 'like', "%{$this->itemSearch}%")
                        ->orWhereRelation('style_versions.styles.designs', 'id', 'like', "%{$this->itemSearch}%")
                        ->orWhereRelation('style_versions.styles.designs', 'description', 'like', "%{$this->itemSearch}%");
            })
            ->get();
        }
        else
            return [];
	}

	#[Computed]
	public function sizes(){
		return Sizes::get();
	}
    #[Computed]
	public function colourways(){
        return Colourways::with(['style_versions.styles'])->whereRelation('style_versions.styles', 'customers_id', '=', $this->form->orderEdit['customers_id'])->whereRelation('style_versions.styles', 'seasons_id', '=', $this->form->orderEdit['seasons_id'])->get();
	}

	#[On('edit-order')]
	public function run($order){
        $order = CustomerOrders::select(
                'id','departments_id','seasons_id','customers_id','incoterms','customer_addresses_id','customer_po','cust_ship_no','order_date','sent_to_factory','incomplete_flag','order_type','cancelled','shipment_mode','phase_id'
            )
            ->with([
                'customer_order_files:id,customer_orders_id,filename,file',
                'customer_order_lines' => function($q){
                    $q->select('id','customer_orders_id','colourways_id','cancelled')
                        ->withCount('shipment_lines')
                        ->with([
                            'colourways:id,style_versions_id,name,cancelled,colour_type' => [
                                'style_versions:id,styles_id,factory_id,name' => [
                                    'styles:id,designs_id,customer_ref' => [
                                        'designs:id,description'
                                    ],
                                    'factories:id,name',
                                ],
                            ],
                        ]);
                },
                'customers:id,name,currency',
                'seasons:id,locked',
                'departments:id,description',
                'customer_addresses:id,name',
                'phase:id,name'
            ])
            ->find($order);

        // Check if any line has multiple shipment lines using withCount
        foreach($order->customer_order_lines as $line){
            if(($line->shipment_lines_count ?? 0) > 1){
                // dd(count($line->shipment_lines));
                $this->quickAdd = FALSE;
                $this->multipleShipmentLines = TRUE;
            }
        }



        if($order->seasons->locked)
            $this->viewOnly = TRUE;
		$this->order = $order;
		$this->form->open($order);
	}
	#[On('new-order-dev')]
	public function new(){
		$this->new = TRUE;
		$this->form->open();
	}

    #[On('close-modal')]
    public function closeModal(){
        $this->reset('lineEdit');
        $this->form->close();
        // $this->form = new OrdersEditFormDev;
        // $this->reset('form');
    }

    public function editLine($line){
        $this->dispatch('save-order-line');
        $this->quickAdd = FALSE;
        $this->lineEdit = $line;
    }

    public function restoreItem($item){
        CustomerOrderLines::withTrashed()->find($item)->restore();
        $this->run($this->order->id);
        $this->dispatch('restore-item', item: $item);
    }

    public function cancelItem($line, $l){
        $sl = $this->order->customer_order_lines->find($line);
        $sl->cancelled = $sl->cancelled ? 0 : 1;
        $sl->update();
        $this->run($this->order->id);
        $this->dispatch('remove-item', item: $l);
    }

    public function dropItem($line, $l){
        $this->order->customer_order_lines->find($line)->delete();
        $this->run($this->order->id);
        if($this->lineEdit == $line){
            $this->lineEdit = NULL;
        }
        // $this->dispatch('save-order-line');
        $this->dispatch('remove-item', item: $l);
    }

    public function changeItem($line){
        $this->itemPickerChange = TRUE;
        $this->itemPickerLine = $line;
    }

    public function editItem($cw){
        $line = $this->order->customer_order_lines->find($this->itemPickerLine);

        $line->colourways_id = $cw;
        $line->update();

        $this->run($this->order->id);
        $this->dispatch('edit-line', id: $this->itemPickerLine);
		$this->reset(['itemPickerLine', 'itemPickerChange', 'itemPicker']);
    }

    public function addItemToList($cw){
        $line = new CustomerOrderLines;
        $line->colourways_id = $cw;
        $line->customer_orders_id = $this->order->id;
        $line->save();

        $this->run($this->order->id);
		$this->reset("itemToAdd");
	}

    public function getPrice($prices, $colour_type, $colourway){
        // Use price resolution cache instead of Functions::getPrice()
        // Create a temporary quantity object to get price model
        $tempQuantity = new \App\Models\CustomerOrderLineQuantities;
        $tempQuantity->sizes_id = 32; // Default size
        
        // Create a mock customer order line with colourway data
        $tempOrderLine = new \App\Models\CustomerOrderLines;
        $tempOrderLine->colourways_id = $colourway;
        $tempOrderLine->phase_id = null; // Default phase
        
        // Create a mock colourway
        $tempColourway = new \App\Models\Colourways;
        $tempColourway->id = $colourway;
        $tempColourway->colour_type = $colour_type;
        $tempColourway->style_versions_id = $prices->first()->style_versions_id ?? 1;
        
        // Create a mock customer order
        $tempCustomerOrder = new \App\Models\CustomerOrders;
        $tempCustomerOrder->seasons_id = 1; // Default season
        
        $tempOrderLine->colourways = $tempColourway;
        $tempOrderLine->customer_orders = $tempCustomerOrder;
        $tempQuantity->customer_order_lines = $tempOrderLine;
        
        $priceModel = $tempQuantity->price_model;
        if($priceModel && isset($priceModel['quote'])){
            return $priceModel['quote'];
        }
        
        return 'No Price';
    }

    public function totalQty(){
        return $this->form->order->totalSale;
    }

    public function render()
    {
	    Gate::authorize('order:read');
        return view('livewire.sales.orders.orders-edit');
    }

	public function save(){
		Gate::authorize('order:update');
		$this->form->save();
        $this->dispatch('save-order');
        $this->dispatch('refreshData');
	}


	public function deleteFile($file, $id, $dir){
		CustomerOrderFiles::find($id)->delete();
		$this->form->open($this->order);
        $this->run($this->order->id);
	}



}
