<?php

namespace App\Http\Livewire\Production\Yarn;

use App\Models\Seasons;
use Livewire\Component;
use App\Models\Suppliers;
use App\Models\YarnOrder;
use Livewire\Attributes\Computed;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Gate;

class YarnOrdersPO extends Component
{
    public $customer = [], $contact, $comments, $prod;

    protected $rules = [
        'comments' => 'nullable|string|max:5000',
    ];

    public function updatedComments(){
        $this->validate();
        $this->po->comments = $this->comments;
        $this->po->save();
    }

    #[Computed]
    public function po(){
        return YarnOrder::where('id', $this->prod)->with('yarn_order_lines.yarn_order_line_styles.customer_order_lines.colourways.style_versions.styles')->first();
    }

    public function mount($prod = NULL){
        if($prod != NULL){
            $this->prod = $prod;
            $this->comments = $this->po->comments;
            $this->contact['name'] = Auth::user()->name;
            $this->contact['email'] = Auth::user()->email;
            $this->contact['phone'] = Auth::user()->phone;
            $this->seasons = Seasons::select('id', 'description')->orderBy('created_at', 'desc')->get();
            $this->spinners = Suppliers::where('type', 'yarn')->get();
        }
    }
    public function render()
    {
        Gate::authorize('order:read');
        return view('livewire.production.yarn.yarn-orders-p-o');
    }
}
