<?php

namespace App\Http\Livewire\Production\Yarn;

use App\Models\Seasons;
use Livewire\Component;
use App\Models\Customer;
use App\Models\Suppliers;
use App\Models\YarnOrder;
use App\Models\Colourways;
use App\Models\YarnColours;
use Livewire\Attributes\On;
use App\Models\YarnOrderLine;
use Livewire\WithFileUploads;
use App\Models\CustomerOrders;
use App\Models\YarnOrderFiles;
use Livewire\Attributes\Computed;
use App\Models\CustomerOrderLines;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use App\Livewire\Forms\YarnOrderEditForm;
use Illuminate\Support\Facades\Gate;

class YarnOrdersEdit extends Component
{
	use WithFileUploads;

	public $order, $new, $finance = [], $viewOnly;

	public YarnOrderEditForm $form;


    #[Computed(cache: true, key: 'spinners-wherehas-yarns')]
	public function spinners(){
		return Suppliers::has('yarns')->get();
	}
	#[Computed]
	public function suppliers(){
		return Suppliers::allCached();
	}
	#[Computed]
	public function customers(){
		return Customer::allCached();
	}
	#[Computed]
	public function seasons(){
		return Seasons::allCached()->where('locked', FALSE);
	}
	#[Computed]
	public function yarnColours(){
		return YarnColours::with('yarn.counts')->whereRelation('yarn', 'suppliers_id', '=', $this->form->orderEdit['suppliers_id'])->get();
	}
	#[Computed]
	public function yarns(){
		return $this->yarnColours->unique('yarn')->pluck('yarn')->sortBy('description');
	}

	#[Computed]
	public function orders(){
        if($this->form->orderEdit['customers_id']){
            return
            Colourways::select(
                'customer_orders.id as customer_orders_id',
                'customer_order_lines.id as customer_order_lines_id',
                'customer_po',
                'colourway_yarns.yarn_colours_id',
                'colourways.id as colourways_id',
                'colourways.name as colourway',
                'style_versions.name as version',
                'styles.customer_ref as customer_ref',
                'styles.designs_id as design',
            )
            ->join('customer_order_lines', function ($join) {
                $join->on('customer_order_lines.colourways_id', '=', 'colourways.id')
                     ->whereNull('customer_order_lines.deleted_at');   // keep only non-deleted lines
            })
            ->join('style_versions', 'style_versions.id', '=', 'colourways.style_versions_id')
            ->join('styles', 'styles.id', '=', 'style_versions.styles_id')
            ->join('customer_orders', function($join)
            {
                $join->on('customer_orders.id', '=', 'customer_order_lines.customer_orders_id');
                $join->on('customer_orders.customers_id', '=', DB::raw($this->form->orderEdit['customers_id']));
                if(!empty($this->form->orderEdit['seasons_id']))
                    $join->on('customer_orders.seasons_id', '>=', DB::raw($this->form->orderEdit['seasons_id']));

            })
            ->join('colourway_yarns', 'colourway_yarns.colourways_id', '=', 'colourways.id')

            // ->where('style_versions.factory_id', $this->form->orderEdit['deliver_to_id'])
            // ->whereNull('customer_orders.customer_order_lines.delete_at')

            ->get();
        }
        else{
            session()->flash('message', 'Please set customer first.');
            session()->flash('alert-class', 'alert-danger');
        }
	}

	public function render()
    {
        Gate::authorize('order:read');
        return view('livewire.production.yarn.yarn-orders-edit');
    }

	public function updatedFinance($data, $arr){
		foreach($this->finance as $line){
			$id = explode('.', $arr)[0];
			$field = explode('.', $arr)[1];
			YarnOrderLine::where('id', $id)->update([$field => $data]);
		}
	}

    public function updatedForm($data, $var){
        $fields = explode('.', $var);
        if(str_contains($var, 'customer_orders_id')){
            $this->form->orderEdit['yarn_order_lines'][$fields[2]]['yarn_order_line_styles'][$fields[4]]['customer_order_lines_id'] = "";
        }
    }

    #[On('new-prod')]
    public function new(){
        $this->new = 1;
        $this->form->new();
    }

	#[On('edit-prod')]
	public function load($order = NULL){
        // dd($order);
		if(!empty($order)){
            $this->order = YarnOrder::with([
                'seasons',
                'yarn_order_lines.yarn_order_line_styles.customer_order_lines.colourways.colourway_yarns',
                'yarn_order_lines.yarn_order_line_styles.customer_order_lines.colourways.style_versions.styles.designs',
                'yarn_order_lines.yarn_order_line_styles.customer_order_lines.customer_orders',
                'yarn_order_files',
                'yarn_order_lines.yarn_colours'
            ])->find($order);

            foreach ($this->order->yarn_order_lines as $line) {
                foreach ($line->yarn_order_line_styles as $style) {
                    if(!empty($style->customer_order_lines->colourways->colourway_yarns)){
                        $style->customer_order_lines->colourways = $style->customer_order_lines->colourways->colourway_yarns
                            ->where('yarn_colours_id', $line->yarn_colours_id);

                        $style->customer_order_lines->yarn_cost = $style->customer_order_lines->colourways->avg('price');
                        // dd($style->customer_order_lines->colourways->);
                    }
                    // else{
                    //     dd($style->customer_order_lines);
                    // }
                }
            }

			$this->form->set($this->order);
			foreach($this->order->yarn_order_lines as $line){
				$this->finance[$line['id']]['invoice_no'] = $line['invoice_no'];
				$this->finance[$line['id']]['invoiced_qty'] = $line['invoiced_qty'];
				$this->finance[$line['id']]['fn_notes'] = $line['fn_notes'];
			}
		}
		else{
			$this->new = 1;
			$this->form->new();
		}
        // dd($this->order);

	}

    public function isYarnPriceTooLow(int $index, array $style): bool
    {
        $price = data_get($this->form, "orderEdit.yarn_order_lines.{$index}.price");
        $yarnCost = data_get($style, "customer_order_lines.yarn_cost");

        if ($price === null || $yarnCost === null) {
            return false;
        }

        return $price != $yarnCost;
    }

	public function deleteFile($f, $id, $file){
		YarnOrderFiles::destroy($id);
		Storage::delete('storage/' . $file);
		unset($this->form->orderEdit['yarn_order_files'][$f]);
	}
	public function deleteLine($line, $id = 0){
		unset($this->form->orderEdit['yarn_order_lines'][$line]);
        if(!empty($id) || $id == 0)
		    $this->form->deleteLines[] = $id;
	}
	public function addLine(){
		$this->form->orderEdit['yarn_order_lines'][] = [
			'price' => NULL,
			'qty' => NULL,
			'ship_date' => NULL,
			'actual_ship_date' => NULL,
			'delivery_date' => NULL,
			'yarn_colours_id' => NULL,
			'yarn_id' => NULL,
		];
	}
    public function addAllStyles($line, $colour)
    {
        $this->form->orderEdit['yarn_order_lines'][$line]['yarn_order_line_styles'] = [];

        $filteredOrders = collect($this->orders)->filter(function ($order) use ($colour) {
            return $order['yarn_colours_id'] == $colour;
        });

        foreach ($filteredOrders as $s => $style) {
            $this->form->orderEdit['yarn_order_lines'][$line]['yarn_order_line_styles'][$s] = [
                'customer_orders_id' => $style['customer_orders_id'],
                'customer_order_lines_id' => $style['customer_order_lines_id'],
            ];
        }
    }
	public function addStyle($line){
        if($this->form->orderEdit['customers_id']){
		    $this->form->orderEdit['yarn_order_lines'][$line]['yarn_order_line_styles'][] = ['customer_orders_id' => NULL, 'customer_order_lines_id' => NULL];
        }
        else{
            session()->flash('message', 'Please set customer first.');
            session()->flash('alert-class', 'alert-danger');
        }
	}
	public function deleteStyle($line, $style){
		unset($this->form->orderEdit['yarn_order_lines'][$line]['yarn_order_line_styles'][$style]);
	}
	public function save(){
		Gate::authorize('order:update');
		$this->form->update();
		$this->dispatch('close-modal');
	}

    #[On('close-modal')]
    public function close(){
        $this->form->clear();
    }

    public function syncColourPrices()
    {
        Gate::authorize('order:update');

        $this->form->syncColourPrices();   // writes to DB
        $this->form->refreshYarnCosts();   // refreshes the in-memory copy

        session()->flash('message', 'Colourway yarn prices have been updated.');
        session()->flash('alert-class', 'alert-success');
    }
}
