<?php

namespace App\Http\Livewire\Production\Shipments;

use App\Models\Seasons;
use App\Models\ShipmentFiles;
use Livewire\Component;
use App\Models\Shipment;
use App\Helper\Functions;
use App\Models\Suppliers;
use Livewire\Attributes\On;
use App\Models\ShipmentLine;
use Livewire\WithFileUploads;
use Livewire\Attributes\Computed;
use Illuminate\Support\Facades\Gate;
use App\Livewire\Forms\ShipmentEditForm;

class ShipmentsEdit extends Component
{
    use WithFileUploads;
    public ShipmentEditForm $form;
    public $shipment, $viewOnly = 0, $show;

    #[Computed(cache: true, key: 'transporters-where-transporter')]
    public function transporters(){
        return Suppliers::where("type", "transporter")->get();
    }

    #[Computed]
    public function lines(){
        if($this->form->shipmentEdit){
            $lines = ShipmentLine::
            select([
                "styles.seasons_id as seasons_id",
                "customers.currency as cust_currency",
                "suppliers.currency as fact_currency",
                "customer_orders.customer_addresses_id as delivery_address",
                "suppliers.name as factory_name",
                "seasons.locked as season_locked"])

            ->selectRaw("(SELECT sum(qty) FROM shipment_line_sizes sls JOIN sizes ON sizes.id = sls.sizes_id AND sls.shipment_line_id = shipment_lines.id GROUP BY shipment_line_id) AS qty")
            ->selectRaw("(SELECT sum(shipped_qty) FROM shipment_line_sizes sls JOIN sizes ON sizes.id = sls.sizes_id AND sls.shipment_line_id = shipment_lines.id GROUP BY shipment_line_id) total_shipped")
            ->selectRaw("(SELECT CONCAT('[', GROUP_CONCAT(JSON_OBJECT('size', sizes.name, 'sizes_id', sizes.id, 'qty', shipped_qty)), ']') FROM shipment_line_sizes sls JOIN sizes ON sizes.id = sls.sizes_id AND sls.shipment_line_id = shipment_lines.id GROUP BY shipment_line_id) AS shipped_sizes")
            ->selectRaw("(SELECT CONCAT('[', GROUP_CONCAT(JSON_OBJECT('size', sizes.name, 'sizes_id', sizes.id, 'qty', qty)), ']') FROM shipment_line_sizes sls JOIN sizes ON sizes.id = sls.sizes_id AND sls.shipment_line_id = shipment_lines.id GROUP BY shipment_line_id) AS sizes")
            ->selectRaw("(SELECT CONCAT('[',
                                GROUP_CONCAT(JSON_OBJECT('id', p.id,'gmt_trans_currency', p.gmt_trans_currency, 'transport_budget', p.gmt_trans * qty, 'cmt_total', p.cmt * qty,
                                'cmt_total_shipped', p.cmt * total_shipped, 'quote_total', quote * qty,
                                'quote_total_shipped', quote * total_shipped, 'cmt', p.cmt, 'quote',
                                quote, 'quote_status', p.quote_status, 'cmt_status', p.cmt_status, 'sizes_id',
                                p.sizes_id, 'colourways_id', p.colourways_id, 'colour_type', p.colour_type)),
                            ']')
                            FROM prices p WHERE p.style_versions_id=style_versions.id ORDER BY p.sizes_id, p.colourways_id, p.colour_type, p.quote_status DESC LIMIT 1) as prices
                        ")
            ->join("customer_order_lines","customer_order_lines.id","=","shipment_lines.customer_order_lines_id")
            ->join("customer_orders","customer_orders.id","=","customer_order_lines.customer_orders_id")
            ->join("seasons","seasons.id","=","customer_orders.seasons_id")
            ->join("colourways","colourways.id","=","customer_order_lines.colourways_id")
            ->join("style_versions","style_versions.id","=","colourways.style_versions_id")
            ->join("styles","styles.id","=","style_versions.styles_id")
            ->join("suppliers","suppliers.id","=","style_versions.factory_id")
            ->join("customers","customers.id","=","styles.customers_id")
            ->where("shipment_id","=", $this->shipment->id)
            ->get();
            $seasons = Seasons::allCached();
            foreach($lines as $l=>$line){
                $lines[$l]['sizes'] = json_decode($line['sizes']);
            }
            // Use total cache system instead of Functions::addPricing()
            // The total cache system automatically handles pricing calculations
            // when shipment lines are created or updated
            return collect($lines);
        }
        return collect([]);
    }

    #[On('edit-shipment')]
    public function edit($shipment){
        $this->shipment = Shipment::with([
            'transporters',
            'shipment_files',
            'shipment_lines.customer_order_lines.customer_orders',
            'shipment_lines.customer_order_lines.colourways.style_versions.styles.designs',
            'shipment_lines.customer_order_lines.customer_order_line_quantities.customer_order_lines.colourways',
            'shipment_lines.customer_order_lines.customer_order_line_quantities.customer_order_lines.customer_orders',
            'shipment_lines.shipment_line_sizes',
            ])
            ->find($shipment);
        $this->form->set($this->shipment);

        // dd($this->shipment);

        // $lines = ShipmentLine::
        // select([
        //     "seasons.locked as season_locked"])
        // ->join("customer_order_lines","customer_order_lines.id","=","shipment_lines.customer_order_lines_id")
        // ->join("customer_orders","customer_orders.id","=","customer_order_lines.customer_orders_id")
        // ->join("seasons","seasons.id","=","customer_orders.seasons_id")
        // ->where("shipment_id","=", $this->shipment->id)
        // ->get();
    }

    #[On('new-shipment')]
    public function new(){
        $this->form->new();
    }

    #[On('close-modal')]
    public function close(){
        $this->reset('show');
        $this->form->shipment = null;
        $this->form->shipmentEdit = [];
    }

    public function render()
    {
        // dd($this->form->shipment);
        Gate::authorize('shipment:read');
        return view('livewire.production.shipments.shipments-edit');
    }

    public function deleteFile($file, $id, $dir){
        // dd(ShipmentFiles::find($id));
		ShipmentFiles::find($id)->delete();
		$this->edit($this->shipment->id);
	}

    public function save(){
        if(!$this->viewOnly){
            Gate::authorize('shipment:update');
            if($this->form->update()){
                $this->dispatch('refreshData');
                $this->dispatch('close-modal');
            }
        }
    }
}
