<?php

namespace App\Http\Livewire\Production\Reports;

use Livewire\Component;
use Livewire\Attributes\On;
use App\Models\ShipmentLine;

class ShipmentScheduleTotals extends Component
{
    public array $chunks;

    public float $drops;
    public float $gmts;
    public float $cost;
    public float $cmt;
    public float $yarnEUR;
    public float $yarnGBP;
    public float $sale;
    public float $margin;

    public function render()
    {
        return view('livewire.production.reports.shipment-schedule-totals');
    }

    #[On('calcTotals')]
    public function calc(){
        $ids = collect($this->chunks)->flatten(1)->pluck('id')->unique()->toArray();

        $query = ShipmentLine::with([
            'customer_order_lines:id,customer_orders_id,colourways_id,factory_cust_date,wh_cust_date,cancelled' => [
                'customer_orders:id,customers_id,seasons_id,order_date,customer_po,incoterms' => [
                    'seasons:id,description',
                    'customers:id,name,currency,settings,samples_required'
                ],
                'colourways:id,style_versions_id,name,img_thumb,cancelled' => [
                    'style_versions:id,styles_id,factory_id,name' => [
                        'factories:id,name,currency',
                        'styles:id,designs_id,customer_ref,cancelled' => [
                            'designs:id,description'
                        ]
                    ]
                ],
                'customer_order_line_quantities' => [
                    'sizes',
                    'customer_order_lines:id,customer_orders_id,colourways_id' => [
                        'colourways:id,style_versions_id,name,img_thumb'
                    ]
                ]
            ],
            'shipment_line_sizes',


        ])
        ->whereIn('id', $ids);

        $shipmentLines = $query->get();

        $prices = $shipmentLines->pluck('total_prices');

        // dd($shipmentLines->pluck('total_prices'));

        $this->drops = $shipmentLines->count();
        $this->gmts = $shipmentLines->flatMap->shipment_line_sizes->sum('qty');
        $this->cost = $prices->sum('subtotal_base');
        $this->cmt = $prices->sum(function($price) {
            return $price['cmt_base'] ?? $price['cmt'] ?? 0;
        });
        $this->yarnEUR = $prices->sum('yarn_value_euro');
        
        // Convert EUR to GBP using season conversion rates
        $season = \App\Models\Seasons::orderBy('id', 'desc')->first();
        if ($season && $season->euro_rate > 0) {
            $this->yarnGBP = $this->yarnEUR / $season->euro_rate;
        } else {
            // Fallback conversion rate if no season found
            $this->yarnGBP = $this->yarnEUR * 0.85;
        }
        $this->sale = $prices->sum('quote_base'); // check this is base?
        $this->margin = ($this->sale > 0) ? (($this->sale - $this->cost) / $this->sale) * 100 : 0;
    }
}
