<?php

namespace App\Http\Livewire\Production\Reports;

use App\Models\ViewShipmentSchedule;
use Cache;
use App\Models\Seasons;
use Livewire\Component;
use App\Models\Customer;
use App\Models\Shipment;
use App\Helper\Functions;
use App\Models\Suppliers;
use App\Models\Colourways;
use App\Helper\Conversions;
use App\Models\Departments;
use Illuminate\Support\Str;
use Livewire\Attributes\On;
use App\Models\ShipmentLine;
use Livewire\WithPagination;
use App\Models\StyleVersions;
use Livewire\Attributes\Computed;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;
use Intervention\Image\Facades\Image;
use App\Models\ShipmentLineExftyDates;
use Illuminate\Support\Facades\Storage;
use App\Models\CustomerOrderLineCustDates;



class ShipmentScheduleExportFactory extends Component
{
	use WithPagination;

    public $export;
    public function mount($array){
        $this->export = json_decode($array);
    }
	public function render()
	{
		Gate::authorize('shipment:read');

		$drops = $this->efficientGetShipment();

		return view('livewire.production.reports.shipment-schedule-export-factory', [
			'drops' => $drops
			])->layout('layouts.fluid');
	}

	private function efficientGetShipment(){

		$query = ViewShipmentSchedule::whereIn('id', $this->export);



		$results = $query->get();


		foreach($results as $l=>$line){
			$results[$l]->sealer = json_decode($line->sealer);
			$results[$l]->shipment = json_decode($line->shipment);
			$results[$l]->sizes = json_decode($line->sizes);
		}


		return $results;
	}

}
