<?php

namespace App\Http\Livewire\Production\Reports;

use Livewire\Component;
use App\Models\Shipment;
use Livewire\Attributes\On;
use Livewire\Attributes\Computed;
use App\Livewire\Forms\SSEditForm;
use Illuminate\Support\Facades\Gate;

class ShipmentScheduleEdit extends Component
{

    public $selected;

    public SSEditForm $form;

    public function updated($property, $value){
        // Handle form property updates - auto-enable the update checkbox when a value field changes
        if (str_starts_with($property, 'form.') && !str_contains($property, '_update')) {
            $parts = explode('.', $property);
            $field = end($parts); // Get the field name (e.g., 'exfty' from 'form.exfty')
            $updateProperty = $field . '_update';
            $this->form->$updateProperty = TRUE;
        }
    }

    #[Computed]
    public function shipments(){
        return Shipment::with('transporters')->orderBy('created_at', 'desc')->get();
    }

    #[On('edit-ss')]
    public function mount($selected = []){
        // dd($selected);
        $this->selected = $selected;
    }

    public function render()
	{
		// Gate::authorize('shipment:read');
		return view('livewire.production.reports.shipment-schedule-edit');
	}

    public function save(){
        //NEED TO SORT AUTH FOR SHIPMENT AND FINANCE
        // Gate::authorize('shipment:update');
        $this->form->update($this->selected);
        if ($this->form->complete_update || $this->form->collection_update || $this->form->shipment_update || $this->form->exfty_update) {
            $this->dispatch('refreshFullSchedule');
        } else {
            $this->dispatch('refreshRows', $this->selected);
        }
        // Reset the selected items in the parent component
        $this->dispatch('clearSelection');
        $this->dispatch('close-modal');
        $this->form->reset();
    }
}
