<?php

namespace App\Http\Livewire\Production\Reports;

use Livewire\Component;
use App\Models\Shipment;
use Livewire\Attributes\On;
use Livewire\Attributes\Computed;
use App\Livewire\Forms\CPEditForm;
use Illuminate\Support\Facades\Gate;

class CriticalPathEdit extends Component
{

    public $selected;

    public CPEditForm $form;

    public function updated($property, $value){
        // Handle form property updates - auto-enable the update checkbox when a value field changes
        if (str_starts_with($property, 'form.') && !str_contains($property, '_update')) {
            $parts = explode('.', $property);
            $field = end($parts); // Get the field name (e.g., 'exfty' from 'form.exfty')
            $updateProperty = $field . '_update';
            $this->form->$updateProperty = TRUE;
        }
    }

    #[Computed]
    public function shipments(){
        return Shipment::with('transporters')->get();
    }

    #[On('edit-cp')]
    public function mount($selected = []){
        $this->selected = $selected;
    }

    public function render()
	{
		Gate::authorize('order:read');
		return view('livewire.production.reports.critical-path-edit');
	}


    public function save(){
        Gate::authorize('order:update');
        $this->form->update($this->selected);
    }
}