<?php

namespace App\Http\Livewire\Production\Reports;

use Livewire\Component;
use Livewire\Attributes\On;
use App\Models\ShipmentLine;
use Illuminate\Support\Facades\DB;

class CommissionShipmentScheduleTotals extends Component
{
    public array $chunks;

    public float $drops = 0;
    public float $gmts = 0;
    public float $saleValue = 0;
    public float $commissionValue = 0;
    public float $avgCommission = 0;

    public function render()
    {
        return view('livewire.production.reports.commission-shipment-schedule-totals');
    }

    #[On('calcTotals')]
    public function calc(){
        $this->drops = 0;
        $this->gmts = 0;
        $this->saleValue = 0;
        $this->commissionValue = 0;
        $this->avgCommission = 0;

        if (empty($this->chunks)) {
            return;
        }

        // Flatten chunks to get all IDs
        $ids = collect($this->chunks)->flatten()->unique()->toArray();

        if (empty($ids)) {
            return;
        }

        // Query to get commission data for all shipment lines
        $totals = DB::table('shipment_lines as sl')
            ->join('customer_order_lines as col', 'sl.customer_order_lines_id', '=', 'col.id')
            ->join('customer_order_line_quantities as colq', 'col.id', '=', 'colq.customer_order_lines_id')
            ->join('shipment_line_sizes as sls', function($join) {
                $join->on('sl.id', '=', 'sls.shipment_line_id')
                     ->on('colq.sizes_id', '=', 'sls.sizes_id');
            })
            ->whereIn('sl.id', $ids)
            ->selectRaw('
                COUNT(DISTINCT sl.id) as drop_count,
                SUM(sls.qty) as total_garments,
                SUM(sls.qty * COALESCE(colq.price, 0)) as sale_value,
                SUM(sls.qty * COALESCE(colq.price, 0) * (1 - COALESCE(colq.discount, 0) / 100) * (COALESCE(colq.commission, 0) / 100)) as commission_value
            ')
            ->first();

        if ($totals) {
            $this->drops = $totals->drop_count ?? 0;
            $this->gmts = $totals->total_garments ?? 0;
            $this->saleValue = $totals->sale_value ?? 0;
            $this->commissionValue = $totals->commission_value ?? 0;

            // Calculate average commission percentage
            if ($this->saleValue > 0) {
                $this->avgCommission = ($this->commissionValue / $this->saleValue) * 100;
            }
        }
    }
}
