<?php

namespace App\Http\Livewire\Production\Reports;

use Livewire\Component;
use App\Models\Shipment;
use Livewire\Attributes\On;
use Livewire\Attributes\Computed;
use App\Livewire\Forms\SSEditForm;
use Illuminate\Support\Facades\Gate;

class CommissionShipmentScheduleEdit extends Component
{

    public $selected;

    public SSEditForm $form;

    public function updated($property, $value){
        // Handle form property updates - auto-enable the update checkbox when a value field changes
        if (str_starts_with($property, 'form.') && !str_contains($property, '_update')) {
            $parts = explode('.', $property);
            $field = end($parts); // Get the field name (e.g., 'exfty' from 'form.exfty')
            $updateProperty = $field . '_update';
            $this->form->$updateProperty = TRUE;
        }
    }

    public function mount(){
        // Initialize component
    }

    #[On('edit-c-ss')]
    public function loadSelected($selected = []){
        $this->selected = $selected;
        // Clear any previous flash messages
        session()->forget(['message', 'alert-class']);
        // Reset form
        $this->form->clear();
    }

    public function save(){
        if (empty($this->selected)) {
            session()->flash('message', 'No items selected');
            session()->flash('alert-class', 'alert-warning');
            return;
        }

        //NEED TO SORT AUTH FOR SHIPMENT AND FINANCE
        // Gate::authorize('shipment:update');
        
        try {
            $this->form->update($this->selected);
            // Note: SSEditForm sets its own flash messages
        } catch (\Exception $e) {
            \Log::error('Bulk Edit Save Error: ' . $e->getMessage(), [
                'trace' => $e->getTraceAsString()
            ]);
            session()->flash('message', 'Error: ' . $e->getMessage());
            session()->flash('alert-class', 'alert-danger');
            return;
        }

        $this->dispatch('close-modal', name: 'edit-ss');
        $this->dispatch('reset-selected');
        $this->form->clear();
    }

    public function render()
    {
        return view('livewire.production.reports.commission-shipment-schedule-edit');
    }
}
