<?php

namespace App\Http\Livewire\Production\Reports;

use App\Models\Styles;
use Livewire\Component;
use Illuminate\Support\Str;
use Livewire\Attributes\On;
use App\Models\ShipmentLine;
use Livewire\WithPagination;
use Livewire\Attributes\Validate;
use App\Livewire\Forms\AsosCPForm;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;
use App\Http\Livewire\Traits\Filterable;
use App\Http\Livewire\FilterableComponent;

class AsosCriticalPath extends FilterableComponent
{
    use WithPagination;
    use Filterable;

    public $hideFilters = false;

    protected function filterKey(): string
    {
        return 'asoscriticalpathfilters';
    }

    protected function columnsVersion(): float
    {
        return 1.2;
    }

    protected function filters(): array
    {
        return ['view', 'columns', 'paginate', 'search', 'rtd', 'from_date'];
    }

    public function getFilterKeyString(): string
    {
        return $this->filterKey();
    }

    #[On('refresh-columns')]
    public function refresh()
    {
        $this->loadFilterSettings();
    }

    public function updated($propertyName)
    {
        // dd();
        //NEED TO ADD IF AsosCPForm IS IN VALIDATION THEN VALIDATE, IF NOT THEN DONT...
        // Validate individual field
        // $this->validateOnly($propertyName);

        // Check for errors and reset if validation fails
        if ($this->getErrorBag()->has($propertyName)) {
            $this->reset($propertyName);
        } else {
            // Reset pagination only if a relevant property is changed
            if (in_array($propertyName, ['view', 'paginate', 'search', 'rtd', 'from_date'])) {
                $this->resetPage();
            }

            // Save filter settings since validation passed
            $this->saveFilterSettings();
        }
    }

    public function complete($val, $line){
        $this->form->complete($val, $line);
    }

    public AsosCPForm $form;

    #[Validate([
        'paginate' => ['required', 'numeric', 'min:10', 'max:1000'],
        'view' => ['required', 'in:unshipped,financeNC,all'],
        'from_date' => ['nullable', 'date'],
    ])]
    public $paginate = 21, $view = "unshipped", $search, $rtd, $from_date;
    private $sl;
    public $sizes;

    public $columns = [
        'Factory' => TRUE,
        'Image' => TRUE,
        'RT Number' => TRUE,
        'RT Description' => TRUE,
        'PO Number' => TRUE,
        'Customer Reference' => TRUE,
        'Customer Description' => TRUE,
        'Colour' => TRUE,
        'Cost Price' => TRUE,
        'Sell Price' => TRUE,
        '3% Discounted Sell Price' => TRUE,
        'Sizes' => TRUE,
        'Required Exfty' => TRUE,
        'Warehouse' => TRUE,
        'Order Received' => TRUE,
        'Sent to Factory' => TRUE,
        'Margin' => TRUE,
        'Order Value' => TRUE,
        'Cost Value' => TRUE,
        'Gross Profit' => TRUE,
        'Yarn/Spinner' => TRUE,
        'Composition' => TRUE,
        'Colour Approval' => TRUE,
        'Bulk Yarn Ordered' => TRUE,
        'Bulk Yarn In House' => TRUE,
        'Start Knit' => TRUE,
        'Samp No.' => TRUE,
        'Green Seal Approval' => TRUE,
        'Photo Shoot Sample' => TRUE,
        'Accessories' => TRUE,
        'Testing' => TRUE,
        'ASN' => TRUE,
        'ASN Transferred' => TRUE,
        'Shipped Date' => TRUE,
        'Shipped Amount' => TRUE,
        'Shipment Complete' => TRUE,
        'RT Invoice No' => TRUE,
        'Cust Invoice No' => TRUE,
        'CIs & PLs Sent' => TRUE,
        'Factory Invoice No' => TRUE,
        'Payment Ref' => TRUE,
        'BOL Number' => TRUE,
        'BOL Tracking (Factory)' => TRUE,
        'BOL Tracking (RT)' => TRUE,
        'Container number' => TRUE,
        'Container ETA' => TRUE,
    ];

    public function updatedForm($val, $var){
        $this->form->save($val, $var);
    }

    public function go(){

    }

    public function mount()
    {
        // Gate::check('asdasd');
        $this->loadFilterSettings();

        $this->sl = $this->getData();
        $this->form->mount($this->sl->toArray()['data']);
        $this->sizes = $this->sl->pluck('sizes')->collapse()->unique('size')->pluck('size', 'sizes_id');
    }
    public function render()
    {
        if (empty($this->sl)) {
            $this->mount();
        }

        return view('livewire.production.reports.asos-critical-path', ['sl' => $this->sl]);
    }

    public function getStyleCount(Styles $style){
        return $style->style_versions->flatMap(function ($version) {
            return $version->colourways->flatMap(function ($colourway) {
                return $colourway->customer_order_lines;
            });
        })->count();
    }

    public function getData(){
        $query = ShipmentLine::
        select(
            'shipment_lines.*',
            'factories.name as factory',
            'colourways.img_thumb',
            'colourways.id as colourways_id',
            'styles.designs_id as designs_id',
            'seasons.description as season',
            'customer_orders.customer_po',
            'customer_orders.id as customer_orders_id',
            'styles.customer_ref',
            'style_versions.id as style_versions_id',
            'styles.id as styles_id',
            'designs.description',
            'designs.id as designs_id',
            'colourways.name as colourways_name',
            'customers.currency as customer_currency',
            'factories.currency as factory_currency',
            'shipment_lines.exfty',
            'customer_addresses.name as customer_address',

            'colourways.customer_description',
            'customer_orders.received as order_received',
            'customer_orders.phase_id',
            'customer_order_lines.id as customer_order_lines_id',
            'customer_order_lines.order_sent_factory',
            'colourways.composition',
            'colourways.colour_approval_comments',
            'colourways.colour_type',

            'customer_order_lines.bulk_yarn_order_date',
            'customer_order_lines.bulk_yarn_order_comments',
            'customer_order_lines.bulk_yarn_order_delivery_date',
            'customer_order_lines.bulk_yarn_order_delivery_comments',

            'customer_order_lines.start_knit',
            'shipment_lines.start_knit_comments',
            'styles.customer_samp_no',

            'styles.green_seal_approval_comments',
            'styles.photo_shoot_sample_comments',

            'colourways.accessories',
            'colourways.testing_comments',

            'shipment_lines.complete',
            'shipment_lines.id as shipment_lines_id',
            'shipment_lines.asn',
            'shipment_lines.asn_transferred_date',
            'shipment_lines.asn_transferred_comments',
            'shipment_lines.collection_date',
            'shipment_lines.shipped_qty',
            'shipment_lines.rt_invoice',
            'shipment_lines.customer_invoice_no',
            'shipment_lines.factory_invoice',
            'shipment_lines.pl_sent_date',
            'shipment_lines.payment_reference',
            'shipment_lines.bol_reference',
            'shipment_lines.bol_tracking_factory',
            'shipment_lines.bol_tracking_rt',
            'shipment_lines.container_eta',
            'shipment_lines.container_no',
            'shipment_lines.invoiced',
            )
            ->selectRaw("(customers.discount / 100) as cust_discount")
            ->selectRaw("(SELECT CONCAT('[', GROUP_CONCAT(JSON_OBJECT('id', yc.id, 'yarn', y.description, 'count', counts.count, 'colour', yc.description, 'colour_id', yc.id, 'yarn_id', y.id, 'prods', (SELECT CONCAT('[', GROUP_CONCAT(JSON_OBJECT('prod', yo.id, 'actual_ship_date', yol.actual_ship_date, 'ship_date', yol.ship_date)), ']') FROM yarn_orders yo JOIN yarn_order_lines yol ON yol.yarn_order_id = yo.id AND yol.yarn_colours_id = cy.yarn_colours_id JOIN yarn_order_line_styles yols ON yols.yarn_order_lines_id = yol.id AND yols.customer_order_lines_id = customer_order_lines.id))), ']') FROM colourway_yarns cy JOIN yarn_colours yc ON yc.id = cy.yarn_colours_id JOIN yarns y ON y.id = yc.yarn_id JOIN counts ON counts.id = y.counts_id WHERE cy.colourways_id = colourways.id) as yarns")

            ->selectRaw(
                "
                    (SELECT
                        quote
                    FROM prices
                    WHERE style_versions_id = style_versions.id
                        AND (colourways_id = colourways.id OR colourways_id IS NULL)
                        AND (colour_type = colourways.colour_type OR colour_type IS NULL)
                        AND (phase_id = customer_orders.phase_id OR phase_id IS NULL)
                    ORDER BY
                        CASE
                            WHEN quote_status = 'confirmed' THEN 1
                            ELSE 0
                        END DESC,
                        colourways_id IS NOT NULL DESC,
                        colour_type IS NOT NULL DESC,
                        CASE
                            WHEN sizes_id = 1 THEN 0
                            ELSE 1
                        END DESC,
                        min_qty DESC -- Within the matches, prioritize the highest MOQ that satisfies the condition
                    LIMIT 1
                ) as quote
            ")
            ->selectRaw(
                "
                    (SELECT
                        cmt
                    FROM prices
                    WHERE style_versions_id = style_versions.id
                        AND (colourways_id = colourways.id OR colourways_id IS NULL)
                        AND (colour_type = colourways.colour_type OR colour_type IS NULL)
                        AND (phase_id = customer_orders.phase_id OR phase_id IS NULL)
                    ORDER BY
                        CASE
                            WHEN quote_status = 'confirmed' THEN 1
                            ELSE 0
                        END DESC,
                        colourways_id IS NOT NULL DESC,
                        colour_type IS NOT NULL DESC,
                        CASE
                            WHEN sizes_id = 1 THEN 0
                            ELSE 1
                        END DESC,
                        min_qty DESC -- Within the matches, prioritize the highest MOQ that satisfies the condition
                    LIMIT 1
                ) as cmt
            ")
            ->selectRaw(
                "
                    (SELECT
                        id
                    FROM prices
                    WHERE style_versions_id = style_versions.id
                        AND (colourways_id = colourways.id OR colourways_id IS NULL)
                        AND (colour_type = colourways.colour_type OR colour_type IS NULL)
                        AND (phase_id = customer_orders.phase_id OR phase_id IS NULL)
                    ORDER BY
                        CASE
                            WHEN quote_status = 'confirmed' THEN 1
                            ELSE 0
                        END DESC,
                        colourways_id IS NOT NULL DESC,
                        colour_type IS NOT NULL DESC,
                        CASE
                            WHEN sizes_id = 1 THEN 0
                            ELSE 1
                        END DESC,
                        min_qty DESC -- Within the matches, prioritize the highest MOQ that satisfies the condition
                    LIMIT 1
                ) as quote_id
            ")


            ->selectRaw("
            (
                select
                concat(
                    '[',
                    group_concat(
                    JSON_OBJECT(
                        'colq_id', colq.id,
                        'sls_id', sls.id,
                        'size', sizes.name,
                        'sizes_id', sizes.id,
                        'qty', sls.qty,
                        'shipped_qty', sls.shipped_qty
                    ) SEPARATOR ','
                    ),
                    ']'
                )
                from  shipment_line_sizes sls
                join sizes on sizes.id = sls.sizes_id and sls.shipment_line_id = shipment_lines.id
                join customer_order_line_quantities colq on colq.customer_order_lines_id = customer_order_lines.id and colq.sizes_id = sls.sizes_id
                group by sls.shipment_line_id
            ) AS sizes
        ")


        ->selectRaw('COUNT(*) OVER (PARTITION BY colourways.id, shipment_lines.exfty) AS colourway_count')
        ->selectRaw('FIRST_VALUE(shipment_lines.id) OVER (PARTITION BY colourways.id, shipment_lines.exfty ORDER BY shipment_lines.exfty, styles.id, style_versions.factory_id, colourways.id, shipment_lines.id) AS colourway_first')
        ->selectRaw('LAST_VALUE(shipment_lines.id) OVER (PARTITION BY colourways.id, shipment_lines.exfty ORDER BY shipment_lines.exfty, styles.id, style_versions.factory_id, colourways.id, shipment_lines.id) AS colourway_last')

        ->whereRelation('customer_order_lines.customer_orders', 'customers_id', '=', '6')

        ->join('customer_order_lines', 'customer_order_lines.id', '=', 'shipment_lines.customer_order_lines_id')
        ->join('customer_orders', 'customer_orders.id', '=', 'customer_order_lines.customer_orders_id')
        ->join('seasons', 'seasons.id', '=', 'customer_orders.seasons_id')
        ->join('customer_addresses', 'customer_addresses.id', '=', 'customer_orders.customer_addresses_id')
        ->join('customers', 'customers.id', '=', 'customer_orders.customers_id')
        ->join('colourways', 'colourways.id', '=', 'customer_order_lines.colourways_id')
        ->join('style_versions', 'style_versions.id', '=', 'colourways.style_versions_id')
        ->join('suppliers as factories', 'factories.id', '=', 'style_versions.factory_id')
        ->join('styles', 'styles.id', '=', 'style_versions.styles_id')
        ->join('designs', 'designs.id', '=', 'styles.designs_id');

        if($this->view == "unshipped"){
			$query->where('shipment_lines.complete', FALSE);
		}
		if($this->view == "financeNC"){
			$query->where('shipment_lines.invoiced', FALSE);
		}

        if($this->search){
            $query->search($this->search);
        }
        if($this->rtd){
            $query->where('designs.id', $this->rtd);
        }
        if($this->from_date){
            $query->where('shipment_lines.exfty', '>=', $this->from_date);
        }

        $query->orderBy('shipment_lines.exfty', 'asc')
        ->orderBy('styles.id', 'asc')
        ->orderBy('style_versions.factory_id', 'asc')
        ->orderBy('colourways.id', 'asc')
        ->orderBy('shipment_lines_id', 'asc');
        $sl = $query->simplePaginate($this->paginate);

        foreach($sl as $l=>$sline){
            $sline->rowspanStyle =
                $sl ->where('exfty', $sline->exfty)
                    ->where('styles_id', $sline->styles_id)->count();
                $sl[$l]->sizes = array_column(json_decode($sline->sizes, true), null, 'sizes_id');
                $sl[$l]->yarns = json_decode($sline->yarns, true);

                $sl[$l]->description = Str::title($sline->description);
                $sl[$l]->colourways_name = Str::title($sline->colourways_name);
                $sl[$l]->complete = (boolean)$sline->complete;
        }
        return $sl;
    }
}
