<?php

namespace App\Http\Livewire;

use Livewire\Component;
use Livewire\Attributes\On;
use Livewire\Attributes\Locked;
use Illuminate\Support\Facades\Cache;

class NavigationMenuLeft extends Component
{

    #[Locked]
    public $menuOpen = "";

    public function mount(){
        // $this->menuOpen = Cache::pull('test-menuopen');
    }

    public function render()
    {
        $value = Cache::remember('test-menuopen', 30, function () {
            return $this->menuOpen;
        });

        return view('livewire.navigation-menu-left');
    }

    #[On('toggle-dropdown')]
    public function changeMenu($value){
        $this->menuOpen = ($this->menuOpen == $value) ? "" : $value;
    }

    public function switchToCommission()
    {
        auth()->user()->settings(['app-mode' => 'commission']);
        return redirect()->route('commission.dashboard');
    }
}
