<?php

namespace App\Http\Livewire\Management;

use App\Models\Team;
use App\Models\User;
use App\Models\FunctionalRole;
use Livewire\Component;
use Livewire\Attributes\Computed;
use Illuminate\Support\Facades\Gate;

class UsersList extends Component
{

    #[Computed]
    public function users(){
        return User::with('latestAudit', 'teams', 'functionalRoles')
        ->get()
        ->sortByDesc(function ($user) {
            return cache()->get("user-last-seen-{$user->id}");
        });
    }

    #[Computed]
    public function teams(){
        return Team::pluck('name', 'id');
    }

    #[Computed]
    public function functionalRoles(){
        return FunctionalRole::pluck('label', 'id');
    }

    public function render()
    {
        if(Gate::check('admin-only')){
            return view('livewire.management.users-list');
        }

    }

    public function cycleTeamRole($userId, $teamId)
    {
        $user = User::findOrFail($userId);

        $currentRole = $user->teams()->where('team_id', $teamId)->first()?->pivot->role;

        $roles = ['viewer', 'editor', 'admin'];
        $nextRole = $roles[(array_search($currentRole, $roles) + 1) % count($roles)];

        $user->teams()->updateExistingPivot($teamId, ['role' => $nextRole]);
    }

    public function removeFromTeam($userId, $teamId)
    {
        $user = User::findOrFail($userId);
        $user->teams()->detach($teamId);
    }

    public function addToTeam($userId, $teamId, $role = 'viewer')
    {
        $user = User::findOrFail($userId);
        $user->teams()->attach($teamId, ['role' => $role]);
    }

    public function toggleFunctionalRole($userId, $roleId)
    {
        $user = User::findOrFail($userId);
        
        if ($user->functionalRoles()->where('functional_role_id', $roleId)->exists()) {
            $user->functionalRoles()->detach($roleId);
        } else {
            $user->functionalRoles()->attach($roleId);
        }
    }
}
