<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Services\ZohoBooksService;
use Webleit\ZohoBooksApi\Exceptions\ZohoBooksApiException;
use Illuminate\Support\Facades\Session;

class InvoiceComponent extends Component
{
    public $customer_name;
    public $invoice_number;
    public $invoice_date;
    public $due_date;
    public $line_items = [];
    public $invoiceCreated = false;
    public $errorMessage = '';

    public function mount()
    {
        $this->invoice_date = date('Y-m-d');
        $this->due_date = date('Y-m-d', strtotime('+30 days'));
    }

    public function addLineItem()
    {
        $this->line_items[] = [
            'name' => '',
            'quantity' => 1,
            'rate' => 0,
            'description' => '',
        ];
    }

    public function removeLineItem($index)
    {
        unset($this->line_items[$index]);
    }

    public function createInvoice()
    {
        $zohoBooksService = new ZohoBooksService();

        $invoiceData = [
            'customer_name' => $this->customer_name,
            'invoice_number' => $this->invoice_number,
            'invoice_date' => $this->invoice_date,
            'due_date' => $this->due_date,
            'line_items' => $this->line_items,
        ];

        try {
            $invoice = $zohoBooksService->createInvoice($invoiceData);
            $this->invoiceCreated = true;
        } catch (ZohoBooksApiException $e) {
            $this->errorMessage = $e->getMessage();
        }
    }

    public function render()
    {
        return view('livewire.invoice');
    }
}
