<?php

namespace App\Http\Livewire\Imports;

use Gemini;
use OpenAI;
use App\Models\Price;
use App\Models\Sizes;
use Gemini\Data\Blob;
use League\Csv\Writer;
use App\Models\Seasons;
use Livewire\Component;
use App\Models\Customer;
use App\Models\Countries;
use Spatie\PdfToText\Pdf;
use App\Models\Colourways;
use Gemini\Enums\MimeType;
use App\Models\Departments;
use Illuminate\Support\Str;
use Livewire\Attributes\On;
use App\Models\ShipmentLine;
use Smalot\PdfParser\Parser;
use App\Models\StyleVersions;
use Livewire\WithFileUploads;
use App\Models\CustomerOrders;
use Illuminate\Support\Carbon;
use App\Models\CustomerAddress;
use App\Actions\GenerateInvoices;
use App\Models\ShipmentLineSizes;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Validate;
use App\Models\CustomerOrderLines;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Livewire\Attributes\Renderless;
use App\Http\Livewire\BaseComponent;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Gate;
use Maatwebsite\Excel\Facades\Excel;
use App\Imports\ImportExcelWithValues;
use App\Services\Zoho\CustomerService;
use Spatie\PdfToImage\Pdf as PdfToImage;
use App\Models\CustomerOrderLineQuantities;

class ErdosImport extends BaseComponent
{
    use WithFileUploads;

    public $orderFiles = [];
    public $disableUploadButton = false;
    public $results;
    public $rtinvoice = [];
    public ?int $customerInvoice = null;

    public array $zohoCustomers = [];



    // Validation rules
    #[Validate([

    ])]

    // public function mount(CustomerService $customers)
    // {

    //     /** @var \Illuminate\Support\Collection $list */
    //     $list = $customers->all(20079258157);                // ← your org-id

    //     // build a plain array suitable for a <select>
    //     $this->zohoCustomers = $list
    //         ->sortBy('contact_name')
    //         ->pluck('contact_name', 'contact_id')            // [id => "Acme Ltd", …]
    //         ->toArray();
    // }

    #[Renderless]
    public function updatedRtinvoice($val, $sl){
        ShipmentLine::find($sl)->update(['rt_invoice' => $val]);
    }


    public function uploadOrders()
    {
        if (! $this->orderFiles) {
            $this->dispatch('banner', message: 'No files uploaded.');
            return;
        }
        if ($this->buttonDisabled()) {
            $this->dispatch('banner', message: 'Max 30 files.');
            return;
        }

        $parser = new Parser();
        $results = [];

        foreach ($this->orderFiles as $uploadedFile) {
            $results[] = $this->extract($parser, $uploadedFile->getRealPath());
        }

        foreach($results as $l=>$line){
            $sl = ShipmentLine::withSum('shipment_line_sizes', 'shipped_qty')
                ->selectSub(function ($q) {
                    $q->from('customer_order_line_quantities')
                        ->select('price')
                        ->whereColumn('customer_order_lines_id', 'shipment_lines.customer_order_lines_id')
                        ->orderBy('id')
                        ->limit(1);
                }, 'rt_price')
                ->selectSub(function ($q) {
                    $q->from('customer_order_line_quantities')
                        ->select('commission')
                        ->whereColumn('customer_order_lines_id', 'shipment_lines.customer_order_lines_id')
                        ->orderBy('id')
                        ->limit(1);
                }, 'commission')
                ->whereRelation(
                    'customer_order_lines.customer_orders',
                    'customer_po',
                    'like',
                    Str::substr($line['po_number'], 0, -2) . '%'
                )
                ->whereRelation(
                    'customer_order_lines.colourways.style_versions.styles',
                    'customer_ref',
                    'like',
                    $line['product_id']
                )
                ->whereRelation('customer_order_lines.customer_orders.seasons',
                    'description',
                    'like',
                    $line['season'])
                ->whereComplete(true)
                ->whereInvoiced(false)
                ->where(function ($query) {
                    $query->whereNull('rt_invoice')
                          ->orWhere('rt_invoice', '');
                })
                ->having('shipment_line_sizes_sum_shipped_qty', '>', 0)
                ->get();
                // dd($sl);
            $results[$l]['match'] = $this->matchShipmentLines($sl, $line['quantity']);
            if(isset($results[$l]['match'][0])){
                $results[$l]['commission'] = ($line['total_value'] ?? 0) * ($results[$l]['match'][0]->commission / 100);
                $results[$l]['rt_price'] = $results[$l]['match'][0]?->rt_price;
                $results[$l]['commission_percent'] = $results[$l]['match'][0]?->commission;
            }
        }
        $this->results = $results;
    }

    /**
     * Match any combination of ShipmentLine models whose summed
     * shipped_qty == $target. Returns null if no exact combo exists.
     *
     * Safe for up to about 25 lines (2^25 ≈ 33 M bit-masks).
     */
    function matchShipmentLines(Collection $lines, int $target): ?Collection
    {
        // ---------- coerce to int and re-index ----------
        $lines = $lines
            ->map(fn ($l) => tap($l, function ($item) {
                $item->int_qty = (int) round($item->shipment_line_sizes_sum_shipped_qty);
            }))
            ->filter->int_qty           // drop zeros
            ->values();                 // 0-based index

        $n    = $lines->count();
        $max  = 1 << $n;               // 2^n subsets

        for ($mask = 1; $mask < $max; $mask++) {
            $sum    = 0;
            $subset = [];

            for ($i = 0; $i < $n; $i++) {
                if ($mask & (1 << $i)) {
                    $sum    += $lines[$i]->int_qty;
                    $subset[] = $lines[$i];
                }
            }

            if ($sum === $target) {
                return collect($subset);      // 🎯 exact combo
            }
        }

        return null;                           // none found
    }

    private function buttonDisabled(){
        return count($this->orderFiles) > 30;
    }


    public function extract(Parser $parser, string $path): array
    {

        $raw   = $parser->parseFile($path)->getText();
        $raw   = preg_replace('/\h+/u', ' ', $raw);
        $raw   = preg_replace('/ *\R+ */u', "\n", $raw);
        $lines = preg_split('/\R/', $raw);


        $poCandidates = [];

        // Gather all possible POs
        foreach ($lines as $i => $line) {
            // Match "PO：66055103", "PO No. 66055103", etc.
            if (preg_match('/\bPO\s*(?:No\.?|：?)?\s*[:#-]?\s*(\d{7,9})\b/i', $line, $m)) {
                $poCandidates[$m[1]] = ($poCandidates[$m[1]] ?? 0) + 1;
            }

            // Also match any standalone 7–9 digit number
            if (preg_match('/^\s*(\d{7,9})\s*$/', $line, $m)) {
                $poCandidates[$m[1]] = ($poCandidates[$m[1]] ?? 0) + 1;
            }
        }

        // Decide: take the most frequently mentioned PO number
        arsort($poCandidates);
        $poNumber = array_key_first($poCandidates);

        $invoice_no = null;

        foreach (array_reverse($lines) as $line) {
            if (preg_match('/invoice\s*no\.?\s*[:：]?\s*([A-Z0-9-]+)/i', $line, $m)) {
                $invoice_no = $m[1];
                break; // take the **last** match
            }
        }

        preg_match('/^[ \t]*([A-Z]\d{4,})\b/m', $raw, $pid);


        preg_match('/^\s*\d+\s+(\d+)\s+(\d+[.,]\d{2})\s*$/m', $raw, $qp);

        preg_match_all(
            '/\b(?:grand\s*)?(?:sub\s*)?(?:net\s*)?total(?:\s*value|\s*amt|\s*)?' . // label
            '[^0-9]{0,10}' .                          // up to 10 non-digits/separators
            '([£$€]?\s*[0-9]{1,3}(?:[ ,][0-9]{3})*(?:\.[0-9]{2})?)/im', // the amount
            $raw,
            $totMatches
        );

        $invoiceDate = null;

        // 1. Search for a line containing "invoice date" explicitly
        foreach ($lines as $line) {
            if (preg_match('/invoice\s*date\s*[:：]?\s*(20\d{2})[\/\-](\d{1,2})[\/\-](\d{1,2})/i', $line, $m)) {
                $invoiceDate = sprintf('%04d-%02d-%02d', $m[1], $m[2], $m[3]);
                break;
            }
        }
        
        // 2. Fallback: try matching "Invoice date" + PO line near the end of the PDF
        if (!$invoiceDate) {
            foreach (array_reverse($lines) as $line) {
                if (preg_match('/invoice\s*date\s*[:：]?\s*(20\d{2})[\/\-](\d{1,2})[\/\-](\d{1,2})/i', $line, $m)) {
                    $invoiceDate = sprintf('%04d-%02d-%02d', $m[1], $m[2], $m[3]);
                    break;
                }
            }
        }
        
        $totalValue = null;
        
        foreach ($totMatches[1] as $raw) {
            // kill currency symbols, spaces & commas, keep dot (if any)
            $normalised = str_replace(['£', '$', '€', ' ', ','], '', $raw);
        
            // turn "25542.00" or "25542" or "25542,00" into a float
            $float = (float) str_replace(',', '.', $normalised);
        
            if ($float > 0) {
                // convert to int pounds/euros/dollars (25542.00 → 25542)
                $totalValue = $float;
                break;          // first positive match is the grand-total
            }
        }

        return [
            'date'       => Carbon::parse($invoiceDate),
            'po_number'  => $poNumber,
            'invoice_no' => $invoice_no,
            'season'     => Str::afterLast($invoice_no, '-'),
            'product_id' => $pid[1]  ?? null,
            'quantity'   => isset($qp[1]) ? (int) $qp[1] : null,
            'unit_price' => isset($qp[2]) ? (float) $qp[2] : null,
            'total_value' => $totalValue,
        ];
    }



    #[On('render')]
    public function render()
    {
        // Gate::authorize('order:create');
        if($this->buttonDisabled()){
            session()->flash('message', 'Max 30 files.');
            session()->flash('alert-class', 'alert-warning');
        }
        return view('livewire.imports.erdos-import');
    }

    public function createInvoices(){
        $this->sendInvoices();
    }

    public function sendInvoices(): void
    {
        // 1. Build the DTOs synchronously
        $invoices = GenerateInvoices::run($this->customerInvoice);

        // 2. Dispatch the queued job
        SendInvoicesJob::dispatch(
            invoices      : $invoices,
            organisationId: 20079258157                  // <— your Zoho org ID
        );

        // 3. Give UX feedback
        $this->dispatch('banner', message: 'Invoices queued for Zoho.');

        // (Optional) close modal or reset component state here
    }

}
