<?php

namespace App\Http\Livewire\Finance;

use Livewire\Component;
use App\Models\ShipmentLine;
use Livewire\Attributes\Validate;
use App\Http\Livewire\BaseComponent;

class ProdLookup extends BaseComponent
{
    #[Validate([
        'prod' => ['nullable', 'string', 'max:30'],
        'rt' => ['nullable', 'string', 'max:30'],
        'style' => ['nullable', 'string', 'max:30'], 
    ])]
    public $prod, $rt, $style;

    public $editID;

    public function render()
    {
        if(strlen($this->prod) > 2 || strlen($this->rt) > 2 || strlen($this->style) > 2){
            $query = ShipmentLine::with(
                'customer_order_lines.yarn_order_line_styles.yarn_order_lines',
                'customer_order_lines.colourways.style_versions.styles',
                'customer_order_lines.customer_orders',
                'shipments');
                if($this->prod)
                    $query->whereRelation('customer_order_lines.yarn_order_line_styles.yarn_order_lines.yarn_orders', 'yarn_order_id' , '=', $this->prod);
                if($this->rt)
                    $query->where('rt_invoice' , 'like', "%{$this->rt}%");
                if($this->style){
                    $query->whereRelation('customer_order_lines.colourways.style_versions.styles', 'customer_ref' , 'like', "%{$this->style}%");
                    $query->orWhereRelation('customer_order_lines.colourways.style_versions.styles', 'designs_id' , 'like', "%{$this->style}%");
                }
                $shipmentLines = $query->get();
        }

        // dd($shipmentLines);

        // dd($shipmentLines);
        return view('livewire.finance.prod-lookup', ['shipmentLines' => $shipmentLines ?? []]);
    }

}
