<?php

namespace App\Http\Livewire\Finance\Cashflow;

use App\Models\Seasons;
use Livewire\Component;
use App\Models\Cashflow;
use App\Models\Customer;
use App\Models\Countries;
use App\Models\Suppliers;
use App\Helper\Conversions;
use App\Models\Departments;
use Livewire\Attributes\On;
use App\Models\CashflowLine;
use Illuminate\Support\Carbon;
use Livewire\Attributes\Computed;
use App\Http\Livewire\Finance\Cashflow\WhCashflowNew;

class WhCashflowPivotNew extends Component
{
    public $pivot, $cashflowId;
    public function updating($var, $val){
        // dd($this->validate());

        $line = explode('.', $var)[1];
        $id = $this->data[$line]['id'] ?? NULL;
        $field = explode('.', $var)[2];

        if($id){
            CashflowLine::find($id)->update([$field => $val]);
        }
    }

    #[Computed]
    public function seasons(){
        return Seasons::whereHas('styles')->orderBy('created_at', 'desc')->get();
    }

    public function render()
    {
        // dd($this->cashflow);
        if($this->cashflowId){
            $cashflow = Cashflow::with('cashflow_lines.suppliers', 'cashflow_lines.customers')->find($this->cashflowId);

            $cashflow->data = json_decode($cashflow->data);
            $cashflow->total_drops = $cashflow->cashflow_lines->count();
            $cashflow->total_vat = $cashflow->cashflow_lines->sum('vat_base');
            $cashflow->total_exvat = $cashflow->cashflow_lines->sum('total_quote_base');
            $cashflow->total_incvat = $cashflow->cashflow_lines->sum('total_quote_base') + $cashflow->cashflow_lines->sum('vat_base');

            $table = $this->prepPivotData($cashflow->cashflow_lines);
            $this->pivot = $this->makePivot($table);
        }
        return view('livewire.finance.cashflow.wh-cashflow-pivot-new', ['cashflow' => $cashflow]);
    }


    public function prepPivotData($cashflowLines){
        $table = [];
        // dd($cashflowLines);
        foreach($cashflowLines as $s=>$drop){

            // dd($drop);
            $gbp_quote_total = 0;
            $usd_quote_total = 0;
            $euro_quote_total = 0;

            $gbp_cmt_total = 0;
            $usd_cmt_total = 0;
            $euro_cmt_total = 0;

            $gbp_yarn_total = 0;
            $usd_yarn_total = 0;
            $euro_yarn_total = 0;

            $base_quote_total = 0;
            $base_cmt_total = 0;
            $base_yarn_total = 0;

            $qty = 0;
            // if($drop->total_shipped != 0)
            //     $qty = $drop->total_shipped;
            // else
                $qty = $drop->qty;

            switch($drop->sale_currency){
                case '£':
                    $gbp_quote_total = $drop->sale + $drop->vat;
                    break;
                case '$':
                    $usd_quote_total = $drop->sale + $drop->vat;
                    break;
                case '€':
                    $euro_quote_total = $drop->sale + $drop->vat;
                    break;
            }
            switch($drop->cmt_currency){
                case '£':
                    $gbp_cmt_total = $drop->cmt;
                    break;
                case '$':
                    $usd_cmt_total = $drop->cmt;
                    break;
                case '€':
                    $euro_cmt_total = $drop->cmt;
                    break;
            }
            switch($drop->yarn_currency){
                case '£':
                    $gbp_yarn_total = $drop->yarn;
                    break;
                case '$':
                    $usd_yarn_total = $drop->yarn;
                    break;
                case '€':
                    $euro_yarn_total = $drop->yarn;
                    break;
            }

            // Use the stored base currency values instead of on-the-fly conversion
            $base_quote_total = ($drop->total_quote_base ?? 0) + ($drop->vat_base ?? 0); // Add VAT base to base quote
            $base_cmt_total = $drop->total_cmt_base ?? 0;
            $base_yarn_total = $drop->total_yarn_base ?? 0;

            // dd($base_quote_total);
            // dd($drop);

            // if($drop->shipment_lines_id == 5975){
            //     dd($drop, $base_yarn_total);
            // }


            if($drop->factored && !empty($drop->sale_terms)){
                // dd($drop->sale_terms);
                $terms = json_decode($drop->sale_terms, true);
                if(!is_array($terms)){
                    $terms = [];
                }
                foreach ($terms as $term) {
                    $table[] = [ //20% in here
                        'Money In Week' => Carbon::parse($drop->exfty)->addDays((int)($term['days'] ?? 0))->format('o: W'),
                        'Percent Of Total Sale' => 20,
                        'Sales GBP' => ($gbp_quote_total * 0.2) * (((float)($term['percentage'] ?? 0)) / 100),
                        'Sales USD' => ($usd_quote_total * 0.2) * (((float)($term['percentage'] ?? 0)) / 100),
                        'Sales Euro' => ($euro_quote_total * 0.2) * (((float)($term['percentage'] ?? 0)) / 100),

                        'CMT GBP' => 0,
                        'CMT USD' => 0,
                        'CMT Euro' => 0,

                        'Yarn GBP' => 0,
                        'Yarn USD' => 0,
                        'Yarn Euro' => 0,

                        'Base CMT' => 0,
                        'Base Sales' => round(($base_quote_total * 0.2) * (((float)($term['percentage'] ?? 0)) / 100), 2),
                        'Base Yarn' => 0,

                        'Month' => Carbon::parse($drop->exfty)->format('Y: M'),
                        'Week No' => Carbon::parse($drop->exfty)->format('o: W'),
                        'Date' => Carbon::parse($drop->exfty)->format('Y-m-d'),
                        'Customer' => $drop->customers->name,
                        'Order' => $drop->customer_po,
                        'Style' => $drop->customer_ref,
                        'Colourway' => $drop->colour,

                        'Factory' => $drop->suppliers->name,
                        'Spinner' => '', // Not applicable for sales rows
                        'drop' => $drop->shipment_lines_id,

                        'Factoring' => $drop->total_factoring,
                    ];
                }



                $table[] = [ //80% in here
                    'Money In Week' => Carbon::parse($drop->exfty)->next('monday')->format('o: W'),
                    'Percent Of Total Sale' => 80,
                    'Sales GBP' => $gbp_quote_total * 0.8,
                    'Sales USD' => $usd_quote_total * 0.8,
                    'Sales Euro' => $euro_quote_total * 0.8,

                    'CMT GBP' => 0,
                    'CMT USD' => 0,
                    'CMT Euro' => 0,

                    'Yarn GBP' => 0,
                    'Yarn USD' => 0,
                    'Yarn Euro' => 0,

                    'Base CMT' => 0,
                    'Base Sales' => round($base_quote_total * 0.8, 2),
                    'Base Yarn' => 0,

                    'Month' => Carbon::parse($drop->exfty)->format('Y: M'),
                    'Week No' => Carbon::parse($drop->exfty)->format('o: W'),
                    'Date' => Carbon::parse($drop->exfty)->format('Y-m-d'),
                    'Customer' => $drop->customers->name,
                    'Order' => $drop->customer_po,
                    'Style' => $drop->customer_ref,
                    'Colourway' => $drop->colour,

                    'Factory' => $drop->suppliers->name,
                    'Spinner' => '', // Not applicable for sales rows
                    'drop' => $drop->shipment_lines_id,

                    'Factoring' => 0,
                ];

            }
            else{
                $table[] = [ //if not factored
                    'Money In Week' => Carbon::parse($drop->exfty)->addDays((int)($drop->sale_terms ?? 0))->format('o: W'),
                    'Percent Of Total Sale' => 100,
                    'Sales GBP' => $gbp_quote_total,
                    'Sales USD' => $usd_quote_total,
                    'Sales Euro' => $euro_quote_total,

                    'CMT GBP' => 0,
                    'CMT USD' => 0,
                    'CMT Euro' => 0,

                    'Yarn GBP' => 0,
                    'Yarn USD' => 0,
                    'Yarn Euro' => 0,

                    'Base CMT' => 0,
                    'Base Sales' => round($base_quote_total, 2),
                    'Base Yarn' => 0,

                    'Month' => Carbon::parse($drop->exfty)->format('Y: M'),
                    'Week No' => Carbon::parse($drop->exfty)->format('o: W'),
                    'Date' => Carbon::parse($drop->exfty)->format('Y-m-d'),
                    'Customer' => $drop->customers->name,
                    'Order' => $drop->customer_po,
                    'Style' => $drop->customer_ref,
                    'Colourway' => $drop->colour,

                    'Factory' => $drop->suppliers->name,
                    'Spinner' => '', // Not applicable for sales rows
                    'drop' => $drop->shipment_lines_id,

                    'Factoring' => 0,
                ];
            }

            $table[] = [ //CMT VALUES
                'Money In Week' => Carbon::parse($drop->exfty)->addDays((int)($drop->cmt_terms ?? 0))->format('o: W'),
                'Percent Of Total Sale' => 'CMT',
                'Sales GBP' => 0,
                'Sales USD' => 0,
                'Sales Euro' => 0,

                'CMT GBP' => $gbp_cmt_total ?? 0,
                'CMT USD' => $usd_cmt_total ?? 0,
                'CMT Euro' => $euro_cmt_total ?? 0,

                'Yarn GBP' => 0,
                'Yarn USD' => 0,
                'Yarn Euro' => 0,

                'Base CMT' => round($base_cmt_total, 2),
                'Base Sales' => 0,
                'Base Yarn' => 0,

                'Month' => Carbon::parse($drop->exfty)->format('Y: M'),
                'Week No' => Carbon::parse($drop->exfty)->format('o: W'),
                'Date' => Carbon::parse($drop->exfty)->format('Y-m-d'),
                'Customer' => $drop->customers->name,
                'Order' => $drop->customer_po,
                'Style' => $drop->customer_ref,
                'Colourway' => $drop->colour,

                'Factory' => $drop->suppliers->name,
                'Spinner' => '', // Not applicable for CMT rows
                'drop' => $drop->shipment_lines_id,

                'Factoring' => 0,
            ];

            // YARN VALUES - Split by spinner
            $yarnSpinners = WhCashflowNew::getYarnSpinnerBreakdown($drop->shipment_lines_id);
            
            if (empty($yarnSpinners)) {
                // Fallback to original single yarn row if no spinner breakdown available
                $table[] = [ 
                    'Money In Week' => Carbon::parse($drop->exfty)->addDays((int)($drop->yarn_terms ?? 0))->format('o: W'),
                    'Percent Of Total Sale' => 'YARN',
                    'Sales GBP' => 0,
                    'Sales USD' => 0,
                    'Sales Euro' => 0,

                    'CMT GBP' => 0,
                    'CMT USD' => 0,
                    'CMT Euro' => 0,

                    'Yarn GBP' => $gbp_yarn_total ?? 0,
                    'Yarn USD' => $usd_yarn_total ?? 0,
                    'Yarn Euro' => $euro_yarn_total ?? 0,

                    'Base CMT' => 0,
                    'Base Sales' => 0,
                    'Base Yarn' => round($base_yarn_total, 2),

                    'Month' => Carbon::parse($drop->exfty)->format('Y: M'),
                    'Week No' => Carbon::parse($drop->exfty)->format('o: W'),
                    'Date' => Carbon::parse($drop->exfty)->format('Y-m-d'),
                    'Customer' => $drop->customers->name,
                    'Order' => $drop->customer_po,
                    'Style' => $drop->customer_ref,
                    'Colourway' => $drop->colour,

                    'Factory' => $drop->suppliers->name,
                    'Spinner' => 'Mixed/Unknown',
                    'drop' => $drop->shipment_lines_id,

                    'Factoring' => 0,
                ];
            } else {
                // Create separate rows for each yarn spinner
                foreach ($yarnSpinners as $spinner) {
                    $spinnerCostBase = Conversions::convertCurrency($spinner['currency'], '£', $spinner['total_cost'], $drop->seasons_id ?? null);
                    
                    // Distribute yarn costs by currency
                    $spinner_gbp = $spinner_usd = $spinner_euro = 0;
                    switch($spinner['currency']){
                        case '£':
                            $spinner_gbp = $spinner['total_cost'];
                            break;
                        case '$':
                            $spinner_usd = $spinner['total_cost'];
                            break;
                        case '€':
                            $spinner_euro = $spinner['total_cost'];
                            break;
                    }
                    
                    $table[] = [
                        'Money In Week' => Carbon::parse($drop->exfty)->addDays((int)($spinner['payment_terms'] ?? 0))->format('o: W'),
                        'Percent Of Total Sale' => 'YARN - ' . $spinner['spinner_name'] . ' (' . $spinner['percentage'] . '%)',
                        'Sales GBP' => 0,
                        'Sales USD' => 0,
                        'Sales Euro' => 0,

                        'CMT GBP' => 0,
                        'CMT USD' => 0,
                        'CMT Euro' => 0,

                        'Yarn GBP' => $spinner_gbp,
                        'Yarn USD' => $spinner_usd,
                        'Yarn Euro' => $spinner_euro,

                        'Base CMT' => 0,
                        'Base Sales' => 0,
                        'Base Yarn' => round($spinnerCostBase, 2),

                        'Month' => Carbon::parse($drop->exfty)->format('Y: M'),
                        'Week No' => Carbon::parse($drop->exfty)->format('o: W'),
                        'Date' => Carbon::parse($drop->exfty)->format('Y-m-d'),
                        'Customer' => $drop->customers->name,
                        'Order' => $drop->customer_po,
                        'Style' => $drop->customer_ref,
                        'Colourway' => $drop->colour,

                        'Factory' => $drop->suppliers->name,
                        'Spinner' => $spinner['spinner_name'],
                        'drop' => $drop->shipment_lines_id,

                        'Factoring' => 0,
                    ];
                }
            }
            
            // FACTORING VALUES - Separate row if customer is factored and has factoring costs
            if ($drop->factored && $drop->total_factoring > 0) {
                $table[] = [
                    'Money In Week' => Carbon::parse($drop->exfty)->format('o: W'), // Factoring paid at EXFTY (immediate)
                    'Percent Of Total Sale' => 'FACTORING',
                    'Sales GBP' => 0,
                    'Sales USD' => 0,
                    'Sales Euro' => 0,

                    'CMT GBP' => 0,
                    'CMT USD' => 0,
                    'CMT Euro' => 0,

                    'Yarn GBP' => 0,
                    'Yarn USD' => 0,
                    'Yarn Euro' => 0,

                    'Base CMT' => 0,
                    'Base Sales' => 0,
                    'Base Yarn' => 0,

                    'Month' => Carbon::parse($drop->exfty)->format('Y: M'),
                    'Week No' => Carbon::parse($drop->exfty)->format('o: W'),
                    'Date' => Carbon::parse($drop->exfty)->format('Y-m-d'),
                    'Customer' => $drop->customers->name,
                    'Order' => $drop->customer_po,
                    'Style' => $drop->customer_ref,
                    'Colourway' => $drop->colour,

                    'Factory' => $drop->suppliers->name,
                    'Spinner' => '', // Not applicable for factoring
                    'drop' => $drop->shipment_lines_id,

                    'Factoring' => round($drop->total_factoring, 2),
                ];
            }
        }
        return $table;
    }

    public function makePivot($table){
        $pivot = [
            'dataSource' => [
                'dataSourceType' => 'json',
                'data' => $table,
            ],
            "slice" => [
                "rows" => [
                    ["uniqueName" => "Money In Week"],
                    ["uniqueName" => "Factory"],
                    ["uniqueName" => "Spinner"],
                    ["uniqueName" => "Customer"],
                    ["uniqueName" => "Style"],
                    ["uniqueName" => "Colourway"],
                    ["uniqueName" => "Percent Of Total Sale"],
                    ["uniqueName" => "drop"],
                ],
                "columns" => [["uniqueName" => "Measures"]],
                "measures" => [
                    [
                        "uniqueName" => "Sales GBP",
                        "aggregation" => "sum",
                        "format" => "5ry1ljel",
                    ],
                    [
                        "uniqueName" => "Sales Euro",
                        "aggregation" => "sum",
                        "format" => "5ry1lwha",
                    ],
                    [
                        "uniqueName" => "Sales USD",
                        "aggregation" => "sum",
                        "format" => "5ry1m3uv",
                    ],
                    [
                        "uniqueName" => "Base Sales",
                        "aggregation" => "sum",
                        "format" => "5ry1mbp6",
                    ],
                    [
                        "uniqueName" => "CMT Euro",
                        "aggregation" => "sum",
                        "format" => "5ry1mmkk",
                    ],
                    [
                        "uniqueName" => "CMT GBP",
                        "aggregation" => "sum",
                        "format" => "5ry1mux2",
                    ],
                    [
                        "uniqueName" => "CMT USD",
                        "aggregation" => "sum",
                        "format" => "5ry1n3eh",
                    ],
                    [
                        "uniqueName" => "Base CMT",
                        "aggregation" => "sum",
                        "format" => "5ry1nbaa",
                    ],
                    [
                        "uniqueName" => "Yarn Euro",
                        "aggregation" => "sum",
                        "format" => "5ry1mmkk",
                    ],
                    [
                        "uniqueName" => "Yarn GBP",
                        "aggregation" => "sum",
                        "format" => "5ry1mux2",
                    ],
                    [
                        "uniqueName" => "Yarn USD",
                        "aggregation" => "sum",
                        "format" => "5ry1n3eh",
                    ],
                    [
                        "uniqueName" => "Base Yarn",
                        "aggregation" => "sum",
                        "format" => "5ry1nbaa",
                    ],
                    [
                        "uniqueName" => "Factoring",
                        "aggregation" => "sum",
                        "format" => "5ry1nbaa",
                    ],
                ],
            ],
            "formats" => [
                [
                    "name" => "5ry1ljel",
                    "thousandsSeparator" => ",",
                    "decimalSeparator" => ".",
                    "decimalPlaces" => 2,
                    "currencySymbol" => "£",
                    "currencySymbolAlign" => "left",
                    "nullValue" => "",
                    "textAlign" => "right",
                    "isPercent" => false,
                ],
                [
                    "name" => "5ry1lwha",
                    "thousandsSeparator" => ",",
                    "decimalSeparator" => ".",
                    "decimalPlaces" => 2,
                    "currencySymbol" => "€",
                    "currencySymbolAlign" => "left",
                    "nullValue" => "",
                    "textAlign" => "right",
                    "isPercent" => false,
                ],
                [
                    "name" => "5ry1m3uv",
                    "thousandsSeparator" => ",",
                    "decimalSeparator" => ".",
                    "decimalPlaces" => 2,
                    "currencySymbol" => "$",
                    "currencySymbolAlign" => "left",
                    "nullValue" => "",
                    "textAlign" => "right",
                    "isPercent" => false,
                ],
                [
                    "name" => "5ry1mbp6",
                    "thousandsSeparator" => ",",
                    "decimalSeparator" => ".",
                    "decimalPlaces" => 2,
                    "currencySymbol" => "£",
                    "currencySymbolAlign" => "left",
                    "nullValue" => "",
                    "textAlign" => "right",
                    "isPercent" => false,
                ],
                [
                    "name" => "5ry1mmkk",
                    "thousandsSeparator" => ",",
                    "decimalSeparator" => ".",
                    "decimalPlaces" => 2,
                    "currencySymbol" => "€",
                    "currencySymbolAlign" => "left",
                    "nullValue" => "",
                    "textAlign" => "right",
                    "isPercent" => false,
                ],
                [
                    "name" => "5ry1mux2",
                    "thousandsSeparator" => ",",
                    "decimalSeparator" => ".",
                    "decimalPlaces" => 2,
                    "currencySymbol" => "£",
                    "currencySymbolAlign" => "left",
                    "nullValue" => "",
                    "textAlign" => "right",
                    "isPercent" => false,
                ],
                [
                    "name" => "5ry1n3eh",
                    "thousandsSeparator" => ",",
                    "decimalSeparator" => ".",
                    "decimalPlaces" => 2,
                    "currencySymbol" => "$",
                    "currencySymbolAlign" => "left",
                    "nullValue" => "",
                    "textAlign" => "right",
                    "isPercent" => false,
                ],
                [
                    "name" => "5ry1nbaa",
                    "thousandsSeparator" => ",",
                    "decimalSeparator" => ".",
                    "decimalPlaces" => 2,
                    "currencySymbol" => "£",
                    "currencySymbolAlign" => "left",
                    "nullValue" => "",
                    "textAlign" => "right",
                    "isPercent" => false,
                ],
            ],
        ];
        // dd($pivot);
        return $pivot;
    }
}
