<?php

namespace App\Http\Livewire\Finance\Cashflow;

use Livewire\Component;
use App\Models\Cashflow;
use Livewire\Attributes\On;
use Livewire\WithPagination;
use App\Http\Livewire\BaseComponent;

class WhCashflowList extends BaseComponent
{
    use WithPagination;
    public $pivotId;

    #[On('refresh-page')]
    public function render()
    {
        $cashflows = Cashflow::orderBy('created_at', 'desc')->simplePaginate(19);
        return view('livewire.finance.cashflow.wh-cashflow-list', ['cashflows' => $cashflows]);
    }
}
