<?php

namespace App\Http\Livewire\Finance\Cashflow;

use App\Models\Seasons;
use Livewire\Component;
use App\Models\Customer;
use App\Models\Suppliers;
use Livewire\Attributes\On;
use App\Models\CashflowLine;
use Livewire\Attributes\Computed;

class WhCashflowEditData extends Component
{

    // #[Validate([
    //         'data.*.cmt' => 'nullable|numeric|min:0',
    //         'data.*.cmt_terms' => 'nullable|numeric|min:0',
    //         'data.*.cmt_currency' => 'nullable|in:£,$,€',
    //         'data.*.yarn' => 'nullable|numeric|min:0',
    //         'data.*.yarn_terms' => 'nullable|numeric|min:0',
    //         'data.*.yarn_currency' => 'nullable|in:£,$,€',
    //         'data.*.sale' => 'nullable|numeric|min:0',
    //         'data.*.sale_terms' => 'nullable|numeric|min:0',
    //         'data.*.sale_currency' => 'nullable|in:£,$,€',
    //         'data.*.vat' => 'nullable|numeric|min:0',

    //         'data.*.customer_po' => 'nullable',
    //         'data.*.customer_ref' => 'nullable',
    //         'data.*.description' => 'nullable',
    //         'data.*.colour' => 'nullable',
    //         'data.*.incoterms' => 'nullable',
    //         'data.*.exfty' => 'nullable',
    //         'data.*.cashflows_id' => 'nullable',
    //         'data.*.shipment_lines_id' => 'nullable',
    //         'data.*.seasons_id' => 'nullable',
    //         'data.*.suppliers_id' => 'nullable',
    //         'data.*.customers_id' => 'nullable',
    //         'data.*.designs_id' => 'nullable',
    //         'data.*.factored' => 'nullable',
    //         'data.*.qty' => 'nullable',
    //         'data.*.is_complete' => 'nullable',
    //     ])]
    public $data = [];

    public function updating($var, $val){
        // dd($this->validate());

        $line = explode('.', $var)[1];
        $id = $this->data[$line]['id'] ?? NULL;
        $field = explode('.', $var)[2];

        if($id){
            if(empty($val))
                $val = 0;
            CashflowLine::find($id)->update([$field => $val]);
        }
    }

    #[Computed]
    public function seasons(){
        return Seasons::allCached();
    }
    #[Computed]
    public function customers(){
        return Customer::whereHas('styles')->get();
    }
    #[Computed]
    public function factories(){
        return Suppliers::whereHas('style_versions')->get();
    }

    #[On('edit-data')]
    public function load($cashflow)
    {
        $this->data = CashflowLine::where('cashflows_id', $cashflow)->get()->toArray();
    }
}
