<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Http\Livewire\BaseComponent;
use App\Http\Livewire\Traits\Filterable;

abstract class FilterableComponent extends BaseComponent
{
    use Filterable;

    abstract protected function filterKey(): string; // Explicit return type
    abstract protected function columnsVersion(): float; // Explicit return type

    // Default implementation of getDefaultColumns
    protected function getDefaultColumns(): array
    {
        return $this->columns; // Or provide a default column structure here
    }
}
