<?php

namespace App\Http\Livewire\Development\Styles;

use App\Models\Yarn;
use App\Models\Gauge;
use App\Models\Design;
use App\Models\Intake;
use App\Models\Styles;
use App\Models\Seasons;
use Livewire\Component;
use App\Models\Customer;
use App\Models\Suppliers;
use App\Models\Departments;
use App\Models\YarnColours;
use Livewire\Attributes\On;
use Livewire\WithFileUploads;
use App\Models\CommodityCodes;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Renderless;
use Illuminate\Support\Facades\Gate;
use App\Livewire\Forms\StyleEditForm;
use App\Livewire\Forms\StyleEditDetailsForm;

class StyleEdit extends Component
{
    use WithFileUploads;
	public StyleEditForm $form;
	public $new, $designs, $commodity_codes_search, $designs_search, $commodityPicker = FALSE, $designsPicker = FALSE;
	public $style = FALSE, $image, $viewOnly;


	#[Computed]
	public function departments(){
		return Departments::where('hidden', false)->get();
	}
	#[Computed]
	public function seasons(){
		return Seasons::where('locked', FALSE)->get();
	}
	#[Computed]
	public function customers(){
		return Customer::allCached();
	}
	#[Computed]
	public function gauges(){
		return Gauge::allCached();
	}
    #[Computed]
	public function intakes(){
		return Intake::get();
	}
	#[Computed]
	public function factories(){
		return Suppliers::allCached();
	}
	#[Computed]
    public function spinners()
    {
        return Suppliers::whereHas('yarns')->get();
    }

    #[Computed]
    public function yarns()
    {
        return Yarn::select('yarns.id', 'yarns.suppliers_id', 'yarns.description', 'counts.count')->whereIn('suppliers_id', $this->form->getYarnSuppliers())->join('counts', 'counts.id', '=', 'yarns.counts_id')->get();
    }

    #[Computed]
    public function colours()
    {
        return YarnColours::whereIn('yarn_id', $this->form->getYarns())->get();

    }
	public function designs(){
		return Design::search($this->designs_search)->limit(20)->get();


		// if(!empty($this->form->styleEdit['designs_id']) && strlen($this->form->styleEdit['designs_id']) > 2)
		// 	return Design::select('id', 'description')->where('id', 'like', '%' . $this->form->styleEdit['designs_id'] . '%')->orWhere('description', 'like', '%' . $this->form->styleEdit['designs_id'] . '%')->limit(30)->get();
		// else
		// 	return [];
	}

    public function updated($a, $b){
        // dd($a, $b);
    }

	public function commodityCodes(){
		return CommodityCodes::search($this->commodity_codes_search)->get();
	}

	public function pullDesign($design){
		$design = Design::find($design);
		$this->form->styleEdit['designs']['description'] = $design->description;
		$this->form->styleEdit['designs']['customers_id'] = $design->customers_id;
		$this->form->styleEdit['designs']['factory_id'] = $design->factory_id;
		$this->form->styleEdit['designs']['gauge_id'] = $design->gauge_id;

		$this->form->styleEdit['customers_id'] = $design->customers_id;

        $this->form->styleEdit['style_versions'][0]['factory_id'] = $design->factory_id;
        $this->form->styleEdit['style_versions'][0]['gauge_id'] = $design->gauge_id;
        $this->form->styleEdit['style_versions'][0]['name'] = "A";

		if(Styles::where('designs_id', $design->id)->count() > 0)
			$this->form->carryover = 1;

	}

	public function setCommodityCode($code){
		$this->form->styleEdit['commodity_codes_id'] = $code;
		$this->commodityPicker = FALSE;
	}

	public function setDesigns($code){
		$this->form->styleEdit['designs_id'] = $code;
		$this->designsPicker = FALSE;
		$this->pullDesign($code);
	}

    public function cloneVersion($v){
        $this->form->cloneVersion($v);
    }

    public function addVersion(){
        $this->form->addVersion();
    }

	public function addColourway($v)
    {
		$this->form->addColourway($v);
    }

    public function cloneColourway($v, $c, $id = FALSE)
    {
        $colourway = $this->form->styleEdit['style_versions'][$v]['colourways'][$c];
        $colourway['id'] = NULL;
        $colourway['name'] = $colourway['name'] . "CLONE";
        $this->form->styleEdit['style_versions'][$v]['colourways'][] = $colourway;
    }
    public function removeColourway($v, $c, $id = FALSE)
    {
        unset($this->form->styleEdit['style_versions'][$v]['colourways'][$c]);
    }
    public function removeStyleVersion($v)
    {
        $version = $this->form->styleEdit['style_versions'][$v] ?? null;

        if (!$version) {
            return; // nothing to remove
        }

        foreach ($version['colourways'] ?? [] as $colourway) {
            if (!empty($colourway['samples'])) {
                $this->dispatch('notify', 'This version has related samples and cannot be removed.');
                return;
            }
        }

        unset($this->form->styleEdit['style_versions'][$v]);
    }

    public function addYarn($v, $c)
    {
        $this->form->addYarn($v, $c);
    }

    public function cloneYarn($v, $c, $y)
    {
        $cloneFrom = $this->form->styleEdit['style_versions'][$v]['colourways'][$c]['colourway_yarns'][$y];
        $cloneFrom['id'] = NULL;
        $this->form->styleEdit['style_versions'][$v]['colourways'][$c]['colourway_yarns'][] = $cloneFrom;
    }

    public function removeYarn($v, $c, $y)
    {
        unset($this->form->styleEdit['style_versions'][$v]['colourways'][$c]['colourway_yarns'][$y]);
    }

	public function mount($style = 0){

	}

	#[On('new-style')]
	public function new(){
		Gate::authorize('style:update');
		$this->style = TRUE;
		$this->new = TRUE;
		$this->form->new();
	}

	#[On('edit-style')]
	public function edit($style){
		$this->style = TRUE;
		$style = Styles::with(
			'designs',
			'seasons',
			'customers',
			'style_versions.colourways.colourway_yarns.yarn_colours.yarn.suppliers:id,name',
			'style_versions.factories',
			'style_versions.gauges',
			'style_versions.colourways.samples',
		)->find($style);
		$this->image = $style->style_versions?->first()?->colourways->first()->image ?? NULL;
		$this->form->set($style);
        if($style->seasons->locked)
            $this->viewOnly = TRUE;
        $this->js('setTimeout(initializeSelect2)');
	}

    public function updateProperty($property, $value)
    {
        if (str_starts_with($property, 'form.styleEdit.')) {
            $property = substr($property, 15); // Remove the first 5 characters ('form.')
        }
        $this->form->setNestedValue($property, $value);
    }

	public function save()
    {
        // dd($this->form->styleEdit);
        if(!$this->viewOnly){
            Gate::authorize('style:update');
            $this->form->update();
            $this->dispatch('refreshData');
        }
    }

    public function render()
    {
		Gate::authorize('style:read');
        return view('livewire.development.styles.style-edit');
    }
    public function rendered()
    {
		$this->dispatch('test');
        $this->js('setTimeout(initializeSelect2)');
    }
}
